/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.rule;

import edu.sysu.pmglab.ccf.toolkit.filter.IIntFilter;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.exception.CommandParserException;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.rule.IRule;

public class CountRule
implements IRule {
    final IIntFilter rule;
    final IRule[] items;

    public CountRule(IIntFilter rule, String ... items) {
        if (items == null || items.length == 0) {
            throw new CommandParserException("Invalid rule: no items specified");
        }
        this.rule = rule;
        this.items = new IRule[items.length];
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            this.items[i] = options -> options.passed(item);
        }
    }

    public CountRule(IIntFilter rule, IRule ... items) {
        if (items == null || items.length == 0) {
            throw new CommandParserException("Invalid rule: no items specified");
        }
        this.rule = rule;
        this.items = new IRule[items.length];
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) {
                throw new CommandParserException("Invalid rule: null rule object");
            }
            this.items[i] = items[i];
        }
    }

    @Override
    public void validate(CommandOptions options) throws ParameterException {
        if (!this.filter(options)) {
            throw new ParameterException(this.toString());
        }
    }

    @Override
    public boolean filter(CommandOptions options) {
        int count = 0;
        for (IRule item : this.items) {
            if (!item.filter(options)) continue;
            ++count;
        }
        return this.rule.filter(count);
    }
}

