/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.usage.parser.unix;

import edu.sysu.pmglab.commandParser.CommandItem;
import edu.sysu.pmglab.commandParser.CommandParser;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.usage.parser.IParserUsage;
import edu.sysu.pmglab.container.entry.TEntry;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.utils.Assert;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class UnixStyleParserUsage
implements IParserUsage {
    private static final VarInt32RangeList FULL_LEVELS = new VarInt32RangeList().addInterval(0, Integer.MAX_VALUE);
    public final List<TEntry<String, String>> prefixes = new List();
    public final int optionIndent;
    public final int maxLength;
    public final boolean lineBreakAfterOptionName;

    public UnixStyleParserUsage(int optionIndent, int maxLength, boolean lineBreakAfterOptionName) {
        this.optionIndent = optionIndent;
        this.maxLength = maxLength;
        this.lineBreakAfterOptionName = lineBreakAfterOptionName;
    }

    public final String hangingIdentFormat(String string, int firstLineIdent, int hangingIndent, int maxLength) {
        Assert.that(firstLineIdent >= 0 && hangingIndent >= 0 && maxLength >= 0);
        Assert.that(hangingIndent < maxLength);
        StringBuilder blanks = new StringBuilder(hangingIndent);
        for (int i = 0; i < hangingIndent; ++i) {
            blanks.append(" ");
        }
        String[] lines = string.trim().split("\n+");
        StringBuilder formatter = new StringBuilder();
        int count = firstLineIdent;
        boolean lineBreak = false;
        for (String line : lines) {
            if ((line = line.trim()).length() == 0) {
                lineBreak = false;
                continue;
            }
            String[] words = line.split("\\s+");
            if (words.length == 0) {
                lineBreak = false;
                continue;
            }
            if (lineBreak) {
                formatter.append("\n");
                formatter.append((CharSequence)blanks);
                count = hangingIndent;
                lineBreak = false;
            }
            formatter.append(words[0]);
            count += words[0].length();
            for (int j = 1; j < words.length; ++j) {
                if (count + 1 + words[j].length() > maxLength && (double)count >= (double)maxLength * 0.75) {
                    formatter.append("\n");
                    formatter.append((CharSequence)blanks);
                    count = hangingIndent;
                    formatter.append(words[j]);
                    count += words[j].length();
                    continue;
                }
                formatter.append(" ").append(words[j]);
                count += 1 + words[j].length();
            }
            lineBreak = true;
        }
        return formatter.toString();
    }

    @Override
    public UnixStyleParserUsage addItem(String keyword, String document) {
        if (keyword == null || keyword.length() == 0) {
            if (document == null || document.length() == 0) {
                this.prefixes.add(new TEntry<Object, Object>(null, null));
            } else {
                this.prefixes.add(new TEntry<Object, String>(null, document));
            }
        } else if (document == null || document.length() == 0) {
            this.prefixes.add(new TEntry<String, Object>(keyword, null));
        } else {
            this.prefixes.add(new TEntry<String, String>(keyword, document));
        }
        return this;
    }

    @Override
    public String format(CommandParser parser) {
        List<String> lines = new List<String>();
        for (TEntry<String, String> prefix : this.prefixes) {
            if (prefix.getKey() == null && prefix.getValue() == null) {
                lines.add("");
                continue;
            }
            if (prefix.getKey() == null) {
                lines.add(this.hangingIdentFormat(prefix.getValue(), 0, 0, this.maxLength));
                continue;
            }
            if (prefix.getValue() == null) {
                lines.add(this.hangingIdentFormat(prefix.getKey(), 0, 0, this.maxLength));
                continue;
            }
            String header = prefix.getKey() + ": ";
            lines.add(header + this.hangingIdentFormat(prefix.getValue(), header.length(), header.length(), this.maxLength));
        }
        LinkedHashMap groupUsages = new LinkedHashMap();
        for (CommandItem item : parser) {
            OptionUsage usage = item.usage();
            if (usage == null || usage.hidden()) continue;
            if (!groupUsages.containsKey(usage.group())) {
                groupUsages.put(usage.group(), new LinkedHashSet());
            }
            ((Set)groupUsages.get(usage.group())).add(item);
        }
        for (String group : groupUsages.keySet()) {
            StringBuilder blanks = new StringBuilder(this.optionIndent);
            for (int i = 0; i < this.optionIndent; ++i) {
                blanks.append(" ");
            }
            StringBuilder formatter = new StringBuilder(group);
            if (!group.endsWith(":")) {
                formatter.append(":");
            }
            LinkedHashMap<CommandItem, String> names = new LinkedHashMap<CommandItem, String>();
            int maxNameLength = 0;
            for (CommandItem item : (Set)groupUsages.get(group)) {
                StringBuilder name = new StringBuilder();
                if (item.isRequired()) {
                    name.append("*");
                }
                if (item.isRepeated()) {
                    name.append("^");
                }
                name.append(List.wrap(item.names()).filter(itemName -> itemName.length() > 0).toString(","));
                names.put(item, name.toString());
                if (name.length() <= maxNameLength) continue;
                maxNameLength = name.length();
            }
            for (CommandItem item : (Set)groupUsages.get(group)) {
                formatter.append("\n");
                formatter.append((CharSequence)blanks);
                formatter.append((String)names.get(item));
                if (this.lineBreakAfterOptionName) {
                    String formattedItem = this.formatItem(item, this.optionIndent * 2, this.optionIndent * 2, this.maxLength);
                    if (formattedItem.length() <= 0) continue;
                    formatter.append("\n");
                    formatter.append((CharSequence)blanks);
                    formatter.append((CharSequence)blanks);
                    formatter.append(formattedItem);
                    continue;
                }
                for (int i = ((String)names.get(item)).length(); i < maxNameLength + this.optionIndent; ++i) {
                    formatter.append(" ");
                }
                formatter.append(this.formatItem(item, maxNameLength + this.optionIndent * 2, maxNameLength + this.optionIndent * 2, this.maxLength));
            }
            lines.add(formatter.toString());
        }
        return lines.toString("\n");
    }

    private String formatItem(CommandItem command, int identFirstLine, int hangingIndent, int maxLength) {
        OptionUsage usage = command.usage();
        StringBuilder formatter = new StringBuilder();
        if (usage.description().length != 0) {
            formatter.append(List.wrap(usage.description()).toString("\n"));
        }
        if (usage.defaultTo().length() != 0) {
            if (formatter.length() > 0) {
                formatter.append("\n");
            }
            formatter.append("Default: " + usage.defaultTo());
        }
        if (usage.format().length() != 0) {
            if (formatter.length() > 0) {
                formatter.append("\n");
            }
            formatter.append("Format: " + usage.format());
        }
        for (UsageItem item : usage.item()) {
            if (formatter.length() > 0) {
                formatter.append("\n");
            }
            if (item.key().length() == 0) {
                formatter.append(List.wrap(item.value()).toString("\n"));
                continue;
            }
            if (item.value().length == 0) {
                formatter.append(item.key());
                continue;
            }
            formatter.append(item.key() + ": " + List.wrap(item.value()).toString("\n"));
        }
        return this.hangingIdentFormat(formatter.toString(), identFirstLine, hangingIndent, maxLength);
    }
}

