/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.usage.summary;

import edu.sysu.pmglab.ccf.toolkit.filter.IObjectObjectFilter;
import edu.sysu.pmglab.commandParser.CommandOption;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.usage.summary.IParsingSummary;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;

public class DefaultParsingSummary
implements IParsingSummary {
    final List<IObjectObjectFilter<CommandOptions, CommandOption<?>>> filters = new List();

    @Override
    public String format(CommandOptions options) {
        String name;
        StringBuilder message = new StringBuilder();
        List<String> matched = new List<String>();
        StringBuilder builder = new StringBuilder();
        int passedCounter = 0;
        for (CommandOption<?> option : options) {
            name = option.commandItem.name();
            if (!option.passed || !this.applyFilter(options, option)) continue;
            ++passedCounter;
            if (option.arity == 0) {
                builder.setLength(0);
                int offset = 3 + name.length() + 1;
                builder.append("   " + name);
                matched.add(builder.toString());
                continue;
            }
            for (String[] params : option.args) {
                builder.setLength(0);
                int offset = 3 + name.length() + 1;
                builder.append("   " + name);
                builder.append(" ").append(this.hangingIdentFormat(List.wrap(params).toString(" \\\n"), offset, offset, Integer.MAX_VALUE));
                matched.add(builder.toString());
            }
        }
        message.append("Parameter parsing is complete and ").append(passedCounter).append(" out of a total of ").append(options.getParser().numOfItems()).append(" parameters have been parsed.");
        if (matched.size() > 0) {
            message.append("\nOptions in effect: \n").append(matched.toString(" \\\n"));
        }
        matched.clear();
        for (CommandOption<?> option : options) {
            if (option.passed) continue;
            name = option.commandItem.name();
            if (option.commandItem.usage() == null || option.commandItem.defaultValueAsString().length <= 0 || !this.applyFilter(options, option)) continue;
            for (String params : option.commandItem.defaultValueAsString()) {
                builder.setLength(0);
                int offset = 3 + name.length() + 1;
                builder.append("   " + name);
                builder.append(" ").append(this.hangingIdentFormat(params, offset, offset, Integer.MAX_VALUE));
                matched.add(builder.toString());
            }
        }
        if (matched.size() > 0) {
            message.append("\nOptions set by default:\n").append(matched.toString(" \\\n"));
        }
        return message.toString();
    }

    @Override
    public DefaultParsingSummary addFilter(IObjectObjectFilter<CommandOptions, CommandOption<?>> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public final String hangingIdentFormat(String string, int firstLineIdent, int hangingIndent, int maxLength) {
        Assert.that(firstLineIdent >= 0 && hangingIndent >= 0 && maxLength >= 0);
        Assert.that(hangingIndent < maxLength);
        StringBuilder blanks = new StringBuilder(hangingIndent);
        for (int i = 0; i < hangingIndent; ++i) {
            blanks.append(" ");
        }
        String[] lines = string.trim().split("\n+");
        StringBuilder formatter = new StringBuilder();
        int count = firstLineIdent;
        boolean lineBreak = false;
        for (String line : lines) {
            if ((line = line.trim()).length() == 0) {
                lineBreak = false;
                continue;
            }
            String[] words = line.split("\\s+");
            if (words.length == 0) {
                lineBreak = false;
                continue;
            }
            if (lineBreak) {
                formatter.append("\n");
                formatter.append((CharSequence)blanks);
                count = hangingIndent;
                lineBreak = false;
            }
            formatter.append(words[0]);
            count += words[0].length();
            for (int j = 1; j < words.length; ++j) {
                if (count + 1 + words[j].length() > maxLength && (double)count >= (double)maxLength * 0.75) {
                    formatter.append("\n");
                    formatter.append((CharSequence)blanks);
                    count = hangingIndent;
                    formatter.append(words[j]);
                    count += words[j].length();
                    continue;
                }
                formatter.append(" ").append(words[j]);
                count += 1 + words[j].length();
            }
            lineBreak = true;
        }
        return formatter.toString();
    }

    private boolean applyFilter(CommandOptions options, CommandOption<?> option) {
        for (IObjectObjectFilter<CommandOptions, CommandOption<?>> filter : this.filters) {
            if (filter.filter(options, option)) continue;
            return false;
        }
        return true;
    }
}

