/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.validator;

import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.validator.IValidator;
import edu.sysu.pmglab.pyserve.PyConnection;
import java.net.InetSocketAddress;

public enum PyConnectValidator implements IValidator<InetSocketAddress>
{
    INSTANCE;


    @Override
    public void validate(String name, InetSocketAddress address) throws ParameterException {
        try {
            PyConnection conn = new PyConnection(address.getHostName(), address.getPort());
            conn.close();
        }
        catch (Error | Exception e) {
            throw new ParameterException("Unable to connect to PyServe on " + address + ", please check if PyServe is started on the corresponding port.\nIf PyServe service is not available on your device, you can install it with the following steps:\n1. Install Docker service, please refer to official guide at https://docs.docker.com/desktop/\n2. Write the following text file (named Dockerfile):\n    FROM continuumio/anaconda3\n    COPY pyserve/ /pyserve\n    EXPOSE 6400 6401\n    CMD python /pyserve/PyServe.py & jupyter notebook --notebook-dir=/opt/notebooks --ip='*' --port=6401 --NotebookApp.token='' --NotebookApp.password='' --no-browser --allow-root\n3. Build the Docker image named 'pyserve' using the following command: \n    docker build -t pyserve -f Dockerfile .\n4. Start the PyServe service using the following command: \n    docker run --rm -p 6400:6400 -p 6401:6401 -m 8g -d pyserve\nHere, port 6400 on the local machine is mapped to the PyServe service within the Docker container, and port 6401 is mapped to Jupyter within the Docker container (you can access Jupyter in your browser at 127.0.0.1:6401), '-m 8g' specifies the memory allocation for the Docker container.", e);
        }
    }

    public String toString() {
        return "";
    }
}

