/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.validator;

import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.validator.IValidator;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class StringValidator
implements IValidator<String>,
Iterable<String> {
    private final Set<String> values;
    private final boolean ignoreCase;

    public StringValidator(String ... values2) {
        this(false, values2);
    }

    public StringValidator(Iterable<String> values2) {
        this(false, values2);
    }

    public StringValidator(boolean ignoreCase, String ... values2) {
        this.ignoreCase = ignoreCase;
        if (values2 == null) {
            this.values = new LinkedHashSet<String>(0);
        } else {
            this.values = new LinkedHashSet<String>(values2.length);
            for (String value : values2) {
                if (value == null || value.length() <= 0) continue;
                if (ignoreCase) {
                    this.values.add(value.toLowerCase());
                    continue;
                }
                this.values.add(value);
            }
        }
    }

    public StringValidator(boolean ignoreCase, Iterable<String> values2) {
        this.ignoreCase = ignoreCase;
        if (values2 == null) {
            this.values = new LinkedHashSet<String>(0);
        } else {
            this.values = new LinkedHashSet<String>(4);
            for (String value : values2) {
                if (value == null || value.length() <= 0) continue;
                if (ignoreCase) {
                    this.values.add(value.toLowerCase());
                    continue;
                }
                this.values.add(value);
            }
        }
    }

    public String toString() {
        return "{" + new List<String>(this.values).toString(", ") + "}" + (this.ignoreCase ? " (ignore case)" : "");
    }

    @Override
    public void validate(String name, String value) throws ParameterException {
        if (this.ignoreCase) {
            value = value.toLowerCase();
        }
        if (!this.values.contains(value)) {
            throw new ParameterException("Invalid parameter: \"" + name + "\" should be one of the following " + (this.ignoreCase ? "(ignore case)" : "") + this + " (" + value + " given)");
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.iterator();
    }
}

