/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.validator.range;

import edu.sysu.pmglab.commandParser.CommandOption;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.validator.IValidator;
import edu.sysu.pmglab.container.interval.Interval;

public interface IRangeValidator<T extends Number>
extends IValidator<T> {
    @Override
    default public void validate(String name, T value) throws ParameterException {
        if (!this.range().contains((Comparable)value)) {
            throw new ParameterException("Invalid parameter: \"" + name + "\" should in the range of [" + this.range().start() + ", " + this.range().end() + "] (" + value + " given)");
        }
    }

    @Override
    default public T validate(CommandOption<T> option) throws ParameterException {
        if (option.passed) {
            this.validate(option.commandItem.name(), (T)((Number)option.value));
        }
        return (T)((Number)option.value);
    }

    public Interval<T> range();
}

