/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.Edge;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import java.util.PriorityQueue;

public class Graph {
    Bytes graphName;
    double MIN_WEIGHT = 0.01;
    double MIN_PERTURB = 0.01;
    IndexableSet<String> nodeLabels = new LinkedSet<String>();
    List<List<Node>> adjList = new List();

    public Graph(Bytes graphName) {
        this.graphName = graphName;
    }

    public Bytes getGraphName() {
        return this.graphName;
    }

    public void clearAll() {
        this.nodeLabels.clear();
        this.adjList.clear();
    }

    public IndexableSet<String> getNodeLabels() {
        return this.nodeLabels;
    }

    public void addEdges(List<Edge> edges) {
        for (int i = 0; i < edges.size(); ++i) {
            this.nodeLabels.add(edges.get((int)i).src);
            this.nodeLabels.add(edges.get((int)i).dest);
            this.adjList.add(new List());
        }
        for (Edge e : edges) {
            if (Double.isNaN(e.weight) || e.weight < this.MIN_WEIGHT) {
                e.weight = this.MIN_WEIGHT;
            }
            this.adjList.get(this.nodeLabels.indexOf(e.src)).add(new Node(this.nodeLabels.indexOf(e.dest), e.weight));
        }
    }

    public void updateDistance(double alpha) {
        int size = this.adjList.size();
        for (int i = 0; i < size; ++i) {
            List<Node> nodes = this.adjList.get(i);
            for (Node node : nodes) {
                node.distance = 1.0 / Math.pow(node.weight, alpha);
            }
        }
    }

    public void updateDistance(double alpha, Map<Integer, Double> effectScoreMap) {
        int size = this.adjList.size();
        for (int i = 0; i < size; ++i) {
            List<Node> nodes = this.adjList.get(i);
            Double perturb1 = effectScoreMap.get(i);
            if (perturb1 == null || perturb1.isNaN()) {
                perturb1 = 1.0;
            } else if ((perturb1 = Double.valueOf(1.0 - perturb1)) == 0.0) {
                perturb1 = this.MIN_PERTURB;
            }
            for (Node node : nodes) {
                Double perturb2 = effectScoreMap.get(node.id);
                if (perturb2 == null || perturb2.isNaN()) {
                    perturb2 = 1.0;
                } else if ((perturb2 = Double.valueOf(1.0 - perturb2)) == 0.0) {
                    perturb2 = this.MIN_PERTURB;
                }
                node.distance = 1.0 / Math.pow(node.weight * perturb1 * perturb2, alpha);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String label : this.nodeLabels) {
            sb.append(label).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    public Map<Integer, Double> calcDijkstraDist(int src) {
        THashMap<Integer, Double> nodeDistMap = new THashMap<Integer, Double>();
        boolean[] visited = new boolean[this.adjList.size()];
        if (visited.length == 1) {
            nodeDistMap.put(1, this.adjList.get((int)0).get((int)0).distance);
            return nodeDistMap;
        }
        PriorityQueue<Pair> prioQue = new PriorityQueue<Pair>();
        prioQue.add(new Pair(src, 0.0));
        while (prioQue.size() > 0) {
            Pair topEle = (Pair)prioQue.remove();
            if (visited[topEle.vertexID]) continue;
            visited[topEle.vertexID] = true;
            nodeDistMap.put(topEle.vertexID, topEle.dsf);
            for (Node edge : this.adjList.get(topEle.vertexID)) {
                if (visited[edge.id]) continue;
                prioQue.add(new Pair(edge.id, topEle.dsf + edge.distance));
            }
        }
        prioQue = null;
        return nodeDistMap;
    }

    public double[][] calcGraphShortDistanceMatrix() {
        int nodeNum = this.nodeLabels.size();
        double[][] distanceMatrix = new double[nodeNum][nodeNum];
        for (int i = 0; i < nodeNum; ++i) {
            Map<Integer, Double> nodeDisMap = this.calcDijkstraDist(i);
            for (int j = i + 1; j < nodeNum; ++j) {
                Double dis = nodeDisMap.get(j);
                distanceMatrix[i][j] = dis == null ? 1000.0 : dis;
                distanceMatrix[j][i] = distanceMatrix[i][j];
            }
        }
        return distanceMatrix;
    }

    public double calcGraphCloseness() {
        int nodeNum = this.nodeLabels.size();
        double[][] distanceMatrix = this.calcGraphShortDistanceMatrix();
        double closeness = 0.0;
        for (int i = 0; i < nodeNum; ++i) {
            for (int j = i + 1; j < nodeNum; ++j) {
                closeness += 1.0 / Math.pow(2.0, distanceMatrix[i][j]);
            }
        }
        return closeness;
    }

    public static void main(String[] args) {
        List<Edge> edges = List.wrap(new Edge[]{new Edge(0, 1, 2.0), new Edge(0, 2, 4.0), new Edge(1, 2, 4.0), new Edge(2, 0, 5.0), new Edge(2, 1, 4.0), new Edge(3, 2, 3.0), new Edge(4, 5, 1.0), new Edge(5, 4, 3.0)});
        List<Edge> edges1 = new List<Edge>();
        edges1.add(new Edge(0, 1, 14.0));
        edges1.add(new Edge(0, 3, 5.0));
        edges1.add(new Edge(1, 0, 14.0));
        edges1.add(new Edge(1, 4, 2.0));
        edges1.add(new Edge(1, 2, 6.0));
        edges1.add(new Edge(2, 1, 6.0));
        edges1.add(new Edge(2, 5, 1.0));
        edges1.add(new Edge(2, 6, 7.0));
        edges1.add(new Edge(3, 0, 5.0));
        edges1.add(new Edge(3, 4, 3.0));
        edges1.add(new Edge(4, 3, 3.0));
        edges1.add(new Edge(4, 1, 2.0));
        edges1.add(new Edge(5, 2, 1.0));
        edges1.add(new Edge(5, 6, 8.0));
        edges1.add(new Edge(6, 2, 7.0));
        edges1.add(new Edge(6, 5, 8.0));
        for (Edge edge : edges) {
        }
        Graph graph = new Graph(new Bytes("Test"));
        graph.addEdges(edges1);
        double alpha = 0.5;
        graph.updateDistance(alpha);
        double closeness = graph.calcGraphCloseness();
        System.out.println(closeness);
        System.out.println(graph.toString());
    }

    static class Pair
    implements Comparable<Pair> {
        int vertexID;
        double dsf;

        Pair(int vertexID, double dsf) {
            this.vertexID = vertexID;
            this.dsf = dsf;
        }

        @Override
        public int compareTo(Pair o) {
            return Double.compare(this.dsf, o.dsf);
        }
    }

    static class Node {
        int id;
        double weight;
        double distance;

        Node(int value, double weight) {
            this.id = value;
            this.weight = weight;
        }
    }
}

