/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.LiteTable;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.format.NumberFormatter;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import edu.sysu.pmglab.io.text.writer.IHeaderFormatter;
import edu.sysu.pmglab.io.text.writer.TextWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.AbstractCollection;

public class Individuals {
    static final FieldGroupMeta FIELDS = new FieldGroupMeta().addField("FID", FieldType.string).addField("IID", FieldType.string).addField("PID", FieldType.string).addField("MID", FieldType.string).addField("SEX", FieldType.int32).addField("phenotype", FieldType.float64Array).addField("hasGenotypes", FieldType.bool).addField("covarTraits", FieldType.float64Array).addField("UID", FieldType.string);
    public static final String INDIVIDUALS_TABLE_KEY = "$INDIVIDUALS_TABLE";
    final LiteTable individuals;
    final IndexableSet<String> UIDs;

    public static void addField(String name, IFieldType type) {
        FIELDS.addField(name, type);
    }

    public Individuals() {
        this.individuals = new LiteTable(FIELDS);
        this.UIDs = new LinkedSet<String>();
    }

    private Individuals(LiteTable individuals, IndexableSet<String> UIDs) {
        this.individuals = individuals;
        this.UIDs = UIDs;
    }

    public CCFMetaItem save() {
        return new CCFMetaItem(INDIVIDUALS_TABLE_KEY, FieldType.bytecode, this.individuals.encode());
    }

    public static Individuals load(Bytes bytes) {
        LiteTable table = LiteTable.decode(bytes);
        LinkedSet UIDs = new LinkedSet();
        for (IRecord record : table.records()) {
            ((AbstractCollection)UIDs).add(record.get("UID"));
        }
        return new Individuals(table.asUnmodifiable(), UIDs.asUnmodifiable());
    }

    public IndexableSet<String> getUIDs() {
        return this.UIDs.asUnmodifiable();
    }

    public boolean isEmpty() {
        return this.UIDs.isEmpty();
    }

    public <T> T get(String UID, String field) {
        return (T)this.individuals.get(this.UIDs.indexOf(UID), field);
    }

    public <T> T get(int UIDIndex, String field) {
        return (T)this.individuals.get(UIDIndex, field);
    }

    public Individuals set(String UID, String field, Object value) {
        this.individuals.set(this.UIDs.indexOf(UID), field, value);
        return this;
    }

    public Individuals set(int UIDIndex, String field, Object value) {
        this.individuals.set(UIDIndex, field, value);
        return this;
    }

    public Individuals clear() {
        this.UIDs.clear();
        this.individuals.clearRecords();
        return this;
    }

    public void export2PlinkFamFile(File outputPath) throws IOException {
        TextRecord input;
        TextReader reader = TextReader.setInput(outputPath).setHeaderParser(IHeaderParser.beginWith("ID", false)).setMetadataParser(IMetadataParser.BEGIN_WITH_1_NUMBER_SIGN).setSeparator(Separator.TAB).instance();
        String[] outputCols = new String[]{"FID", "IID", "PID", "MID", "SEX", "phenotype", "covarTraits"};
        TextWriter writer = TextWriter.setOutput(outputPath + ".tmp").setHeaderFormatter(IHeaderFormatter.NO_HEADER_LINE).addFields(outputCols).instance();
        IndexableSet<String> uIDs = this.getUIDs();
        TextRecord output = writer.getRecord();
        while ((input = reader.read()) != null) {
            for (int i = 0; i < 5; ++i) {
                output.set(i, input.get(i));
            }
            IRecord record = this.individuals.get(uIDs.indexOf(output.get("IID").toString()));
            double pheno = (Double)record.get("phenotype");
            output.set(5, NumberFormatter.convertDoubleToStringWithoutTrailingZeros(pheno));
            double[] covars = (double[])record.get("covarTraits");
            for (int i = 0; i < covars.length; ++i) {
                output.set(i + 6, NumberFormatter.convertDoubleToStringWithoutTrailingZeros(covars[i]));
            }
            writer.write(output);
        }
        writer.close();
        reader.close();
        String oldFilePath = outputPath.getCanonicalPath();
        Files.move(Paths.get(outputPath + ".tmp", new String[0]), Paths.get(oldFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public void export2PlinkSamFile(File outputPath) throws IOException {
        TextRecord input;
        TextReader reader = TextReader.setInput(outputPath).setHeaderParser(IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN).setMetadataParser(IMetadataParser.BEGIN_WITH_1_NUMBER_SIGN).setSeparator(Separator.TAB).instance();
        String[] outputCols = new String[]{"IID", "SID", "PAT", "MAT", "SEX", "phenotype", "covarTraits"};
        TextWriter writer = TextWriter.setOutput(outputPath + ".tmp").setHeaderFormatter(IHeaderFormatter.BEGIN_WITH_1_NUMBER_SIGN).addFields(outputCols).instance();
        IndexableSet<String> uIDs = this.getUIDs();
        TextRecord output = writer.getRecord();
        while ((input = reader.read()) != null) {
            output.set(0, input.get(0));
            IRecord record = this.individuals.get(uIDs.indexOf(output.get(0).toString()));
            output.set("SID", record.get("FID").toString());
            output.set("PAT", record.get("PID").toString());
            output.set("MAT", record.get("MID").toString());
            output.set("SEX", record.get("SEX").toString());
            double pheno = (Double)record.get("phenotype");
            output.set(5, NumberFormatter.convertDoubleToStringWithoutTrailingZeros(pheno));
            double[] covars = (double[])record.get("covarTraits");
            for (int i = 0; i < covars.length; ++i) {
                output.set(i + 6, NumberFormatter.convertDoubleToStringWithoutTrailingZeros(covars[i]));
            }
            writer.write(output);
        }
        writer.close();
        reader.close();
        String oldFilePath = outputPath.getCanonicalPath();
        Files.move(Paths.get(outputPath + ".tmp", new String[0]), Paths.get(oldFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public synchronized IRecord add(String UID, Object ... values2) {
        if (this.UIDs.contains(UID)) {
            IRecord record = this.individuals.get(this.UIDs.indexOf(UID));
            for (int i = 0; i < Math.min(values2.length, this.individuals.numOfFields()); ++i) {
                record.set(i, values2[i]);
            }
            return record;
        }
        this.UIDs.add(UID);
        return this.individuals.alloc(values2);
    }

    public int size() {
        return this.UIDs.size();
    }

    public int indexOf(String UID) {
        return this.UIDs.indexOf(UID);
    }
}

