/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.array;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.iterator.FilterIterator;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

public class Array<T>
implements Iterable<T> {
    Object[] data;

    public Array(int size) {
        this.data = size == 0 ? EmptyArray.OBJECT : new Object[size];
    }

    public Array(Object[] array) {
        Assert.that(array != null);
        this.data = array.length == 0 ? EmptyArray.OBJECT : array;
    }

    public Array(T array) {
        this.data = new Object[]{array};
    }

    public boolean setLength(int length) {
        if (length == 0) {
            if (this.data != EmptyArray.OBJECT) {
                this.data = EmptyArray.OBJECT;
                return true;
            }
        } else if (this.data.length != length) {
            this.data = Arrays.copyOf(this.data, length);
            return true;
        }
        return false;
    }

    public boolean ensureIndex(int index) {
        if (this.data.length <= index) {
            this.data = Arrays.copyOf(this.data, index + 1);
            return true;
        }
        return false;
    }

    public void fill(T value) {
        Arrays.fill(this.data, value);
    }

    public Object[] getData() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public boolean contains(Object element) {
        if (element == null) {
            for (Object datum : this.data) {
                if (null != datum) continue;
                return true;
            }
        } else {
            for (Object datum : this.data) {
                if (!element.equals(datum)) continue;
                return true;
            }
        }
        return false;
    }

    public Array<T> subArray(int fromIndex, int toIndex) {
        return new Array<Object[]>(Arrays.copyOfRange(this.data, fromIndex, toIndex));
    }

    public T get(int index) {
        return (T)this.data[index];
    }

    public T lastGet(int index) {
        return (T)this.data[this.data.length - 1 - index];
    }

    public T set(int index, T newValue) {
        this.data[index] = newValue;
        return (T)this.data[index];
    }

    public T lastSet(int index, T newValue) {
        T t = newValue;
        this.data[this.data.length - 1 - index] = t;
        return t;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Array)) {
            return false;
        }
        Array array = (Array)o;
        if (this.data == array.data) {
            return true;
        }
        if (array.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (Objects.equals(this.data[i], array.data[i])) continue;
            return false;
        }
        return true;
    }

    public Array<T> clone() {
        return new Array<Object[]>(Arrays.copyOf(this.data, this.data.length));
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public boolean all(IFilter<T> rule) {
        for (Object datum : this.data) {
            if (rule.filter(datum)) continue;
            return false;
        }
        return true;
    }

    public boolean any(IFilter<T> rule) {
        for (Object datum : this.data) {
            if (!rule.filter(datum)) continue;
            return true;
        }
        return false;
    }

    public int count(IFilter<T> rule) {
        int count = 0;
        for (Object datum : this.data) {
            if (!rule.filter(datum)) continue;
            ++count;
        }
        return count;
    }

    public IndexableSet<T> toSet() {
        LinkedSet<Object> values2 = new LinkedSet<Object>(this.data.length);
        for (Object datum : this.data) {
            values2.add(datum);
        }
        return values2;
    }

    public IndexableSet<T> toUnmodifiableSet() {
        return this.toSet().asUnmodifiable();
    }

    public IndexIterator where(IFilter<T> function) {
        return new IndexIterator(this.data.length, function == null ? null : index -> function.filter(this.get(index)));
    }

    public void apply(Function<T, T> function) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = function.apply(this.data[i]);
        }
    }

    public int indexOf(Object element) {
        if (element == null) {
            for (int i = 0; i < this.data.length; ++i) {
                if (null != this.data[i]) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                if (!element.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfIf(IFilter<T> condition) {
        if (condition == null) {
            return -1;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!condition.filter(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString(String joiner) {
        return List.wrap(joiner).toString(joiner);
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.data.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            Object temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
    }

    public Array<T> asUnmodifiable() {
        return new Array<T>(this.data){

            @Override
            public boolean setLength(int length) {
                if (length != this.length()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public boolean ensureIndex(int index) {
                if (this.data.length <= index) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public void fill(T value) {
                if (this.length() >= 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public T set(int index, T newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public T lastSet(int index, T newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void shuffle(long seed) {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public Array<T> asUnmodifiable() {
                return this;
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int pointer = 0;

            @Override
            public boolean hasNext() {
                return this.pointer < Array.this.length();
            }

            @Override
            public T next() {
                return Array.this.get(this.pointer++);
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator<T> filter(IFilter<T> filter) {
        return new FilterIterator<T>(this, filter);
    }
}

