/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.array;

import edu.sysu.pmglab.ccf.toolkit.filter.IByteFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import gnu.trove.TCollections;
import gnu.trove.function.TByteFunction;
import gnu.trove.iterator.TByteIterator;
import gnu.trove.set.TByteSet;
import gnu.trove.set.hash.TByteHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class ByteArray {
    byte[] data;

    public ByteArray(int size) {
        this.data = size == 0 ? EmptyArray.BYTE : new byte[size];
    }

    public ByteArray(byte[] array) {
        Assert.that(array != null);
        this.data = array.length == 0 ? EmptyArray.BYTE : array;
    }

    public boolean setLength(int length) {
        if (length == 0) {
            if (this.data != EmptyArray.BYTE) {
                this.data = EmptyArray.BYTE;
                return true;
            }
        } else if (this.data.length != length) {
            this.data = Arrays.copyOf(this.data, length);
            return true;
        }
        return false;
    }

    public boolean ensureIndex(int index) {
        if (this.data.length <= index) {
            this.data = Arrays.copyOf(this.data, index + 1);
            return true;
        }
        return false;
    }

    public void fill(byte value) {
        Arrays.fill(this.data, value);
    }

    public byte[] getData() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public boolean contains(byte element) {
        for (byte datum : this.data) {
            if (element != datum) continue;
            return true;
        }
        return false;
    }

    public ByteArray subArray(int fromIndex, int toIndex) {
        return new ByteArray(Arrays.copyOfRange(this.data, fromIndex, toIndex));
    }

    public byte get(int index) {
        return this.data[index];
    }

    public byte lastGet(int index) {
        return this.data[this.data.length - 1 - index];
    }

    public byte set(int index, byte newValue) {
        this.data[index] = newValue;
        return this.data[index];
    }

    public byte offset(int index, byte offset) {
        int n = index;
        byte by = (byte)(this.data[n] + offset);
        this.data[n] = by;
        return by;
    }

    public byte lastSet(int index, byte newValue) {
        byte by = newValue;
        this.data[this.data.length - 1 - index] = by;
        return by;
    }

    public int hashCode() {
        int hashCode = 0;
        for (byte element : this.data) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ByteArray)) {
            return false;
        }
        ByteArray array = (ByteArray)o;
        if (this.data == array.data) {
            return true;
        }
        if (array.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == array.data[i]) continue;
            return false;
        }
        return true;
    }

    public ByteArray clone() {
        return new ByteArray(Arrays.copyOf(this.data, this.data.length));
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public int argmax() {
        if (this.data.length == 0) {
            return -1;
        }
        byte element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (element >= this.data[i]) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.data.length == 0) {
            return -1;
        }
        byte element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (element <= this.data[i]) continue;
            index = i;
        }
        return index;
    }

    public byte max() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        byte maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (maxValue >= this.data[i]) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public byte sum() {
        byte sum = 0;
        for (byte element : this.data) {
            sum = (byte)(sum + element);
        }
        return sum;
    }

    public byte min() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        byte maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (maxValue <= this.data[i]) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public boolean all(IByteFilter rule) {
        for (byte datum : this.data) {
            if (rule.filter(datum)) continue;
            return false;
        }
        return true;
    }

    public boolean any(IByteFilter rule) {
        for (byte datum : this.data) {
            if (!rule.filter(datum)) continue;
            return true;
        }
        return false;
    }

    public int count(IByteFilter rule) {
        int count = 0;
        for (byte datum : this.data) {
            if (!rule.filter(datum)) continue;
            ++count;
        }
        return count;
    }

    public TByteSet toSet() {
        return new TByteHashSet(this.data);
    }

    public TByteSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(IByteFilter function) {
        return new IndexIterator(this.data.length, function == null ? null : index -> function.filter(this.get(index)));
    }

    public void apply(TByteFunction function) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = function.execute(this.data[i]);
        }
    }

    public void sort() {
        Arrays.sort(this.data);
    }

    public int indexOf(byte element) {
        for (int i = 0; i < this.data.length; ++i) {
            if (element != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(IByteFilter condition) {
        if (condition == null) {
            return -1;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!condition.filter(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString(String joiner) {
        return List.wrap(joiner).toString(joiner);
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.data.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            byte temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
    }

    public ByteArray asUnmodifiable() {
        return new ByteArray(this.data){

            @Override
            public boolean setLength(int length) {
                if (length != this.length()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public boolean ensureIndex(int index) {
                if (this.data.length <= index) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public void fill(byte value) {
                int l = this.length();
                for (int i = 0; i < l; ++i) {
                    if (this.get(i) == value) continue;
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public byte set(int index, byte newValue) {
                if (this.get(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public byte offset(int index, byte offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte lastSet(int index, byte newValue) {
                if (this.lastGet(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public void sort() {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public void shuffle(long seed) {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public ByteArray asUnmodifiable() {
                return this;
            }
        };
    }

    public TByteIterator iterator() {
        return new TByteIterator(){
            int pointer = 0;

            @Override
            public byte next() {
                return ByteArray.this.get(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < ByteArray.this.length();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }
}

