/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.array;

import edu.sysu.pmglab.ccf.toolkit.filter.IDoubleFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import gnu.trove.TCollections;
import gnu.trove.function.TDoubleFunction;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.set.TDoubleSet;
import gnu.trove.set.hash.TDoubleHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class DoubleArray {
    double[] data;

    public DoubleArray(int size) {
        this.data = size == 0 ? EmptyArray.DOUBLE : new double[size];
    }

    public DoubleArray(double[] array) {
        Assert.that(array != null);
        this.data = array.length == 0 ? EmptyArray.DOUBLE : array;
    }

    public boolean setLength(int length) {
        if (length == 0) {
            if (this.data != EmptyArray.DOUBLE) {
                this.data = EmptyArray.DOUBLE;
                return true;
            }
        } else if (this.data.length != length) {
            this.data = Arrays.copyOf(this.data, length);
            return true;
        }
        return false;
    }

    public boolean ensureIndex(int index) {
        if (this.data.length <= index) {
            this.data = Arrays.copyOf(this.data, index + 1);
            return true;
        }
        return false;
    }

    public void fill(double value) {
        Arrays.fill(this.data, value);
    }

    public double[] getData() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public boolean contains(double element) {
        for (double datum : this.data) {
            if (element != datum) continue;
            return true;
        }
        return false;
    }

    public DoubleArray subArray(int fromIndex, int toIndex) {
        return new DoubleArray(Arrays.copyOfRange(this.data, fromIndex, toIndex));
    }

    public double get(int index) {
        return this.data[index];
    }

    public double lastGet(int index) {
        return this.data[this.data.length - 1 - index];
    }

    public double set(int index, double newValue) {
        this.data[index] = newValue;
        return this.data[index];
    }

    public double offset(int index, double offset) {
        int n = index;
        double d = this.data[n] + offset;
        this.data[n] = d;
        return d;
    }

    public double lastSet(int index, double newValue) {
        double d = newValue;
        this.data[this.data.length - 1 - index] = d;
        return d;
    }

    public int hashCode() {
        int hashCode = 0;
        for (double element : this.data) {
            hashCode = (int)((double)(31 * hashCode) + element);
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof DoubleArray)) {
            return false;
        }
        DoubleArray array = (DoubleArray)o;
        if (this.data == array.data) {
            return true;
        }
        if (array.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == array.data[i]) continue;
            return false;
        }
        return true;
    }

    public DoubleArray clone() {
        return new DoubleArray(Arrays.copyOf(this.data, this.data.length));
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public int argmax() {
        if (this.data.length == 0) {
            return -1;
        }
        double element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (!(element < this.data[i])) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.data.length == 0) {
            return -1;
        }
        double element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (!(element > this.data[i])) continue;
            index = i;
        }
        return index;
    }

    public double max() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        double maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (!(maxValue < this.data[i])) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public double sum() {
        double sum = 0.0;
        for (double element : this.data) {
            sum += element;
        }
        return sum;
    }

    public double min() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        double maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (!(maxValue > this.data[i])) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public boolean all(IDoubleFilter rule) {
        for (double datum : this.data) {
            if (rule.filter(datum)) continue;
            return false;
        }
        return true;
    }

    public boolean any(IDoubleFilter rule) {
        for (double datum : this.data) {
            if (!rule.filter(datum)) continue;
            return true;
        }
        return false;
    }

    public int count(IDoubleFilter rule) {
        int count = 0;
        for (double datum : this.data) {
            if (!rule.filter(datum)) continue;
            ++count;
        }
        return count;
    }

    public TDoubleSet toSet() {
        return new TDoubleHashSet(this.data);
    }

    public TDoubleSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(IDoubleFilter function) {
        return new IndexIterator(this.data.length, function == null ? null : index -> function.filter(this.get(index)));
    }

    public void apply(TDoubleFunction function) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = function.execute(this.data[i]);
        }
    }

    public void sort() {
        Arrays.sort(this.data);
    }

    public int indexOf(double element) {
        for (int i = 0; i < this.data.length; ++i) {
            if (element != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(IDoubleFilter condition) {
        if (condition == null) {
            return -1;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!condition.filter(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString(String joiner) {
        return List.wrap(joiner).toString(joiner);
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.data.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            double temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
    }

    public DoubleArray asUnmodifiable() {
        return new DoubleArray(this.data){

            @Override
            public boolean setLength(int length) {
                if (length != this.length()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public boolean ensureIndex(int index) {
                if (this.data.length <= index) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public void fill(double value) {
                int l = this.length();
                for (int i = 0; i < l; ++i) {
                    if (this.get(i) == value) continue;
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public double set(int index, double newValue) {
                if (this.get(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public double offset(int index, double offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double lastSet(int index, double newValue) {
                if (this.lastGet(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public void sort() {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public void shuffle(long seed) {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public DoubleArray asUnmodifiable() {
                return this;
            }
        };
    }

    public TDoubleIterator iterator() {
        return new TDoubleIterator(){
            int pointer = 0;

            @Override
            public double next() {
                return DoubleArray.this.get(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < DoubleArray.this.length();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }
}

