/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.array;

import edu.sysu.pmglab.ccf.toolkit.filter.IFloatFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import gnu.trove.TCollections;
import gnu.trove.function.TFloatFunction;
import gnu.trove.iterator.TFloatIterator;
import gnu.trove.set.TFloatSet;
import gnu.trove.set.hash.TFloatHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class FloatArray {
    float[] data;

    public FloatArray(int size) {
        this.data = size == 0 ? EmptyArray.FLOAT : new float[size];
    }

    public FloatArray(float[] array) {
        Assert.that(array != null);
        this.data = array.length == 0 ? EmptyArray.FLOAT : array;
    }

    public boolean setLength(int length) {
        if (length == 0) {
            if (this.data != EmptyArray.FLOAT) {
                this.data = EmptyArray.FLOAT;
                return true;
            }
        } else if (this.data.length != length) {
            this.data = Arrays.copyOf(this.data, length);
            return true;
        }
        return false;
    }

    public boolean ensureIndex(int index) {
        if (this.data.length <= index) {
            this.data = Arrays.copyOf(this.data, index + 1);
            return true;
        }
        return false;
    }

    public void fill(float value) {
        Arrays.fill(this.data, value);
    }

    public float[] getData() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public boolean contains(float element) {
        for (float datum : this.data) {
            if (element != datum) continue;
            return true;
        }
        return false;
    }

    public FloatArray subArray(int fromIndex, int toIndex) {
        return new FloatArray(Arrays.copyOfRange(this.data, fromIndex, toIndex));
    }

    public float get(int index) {
        return this.data[index];
    }

    public float lastGet(int index) {
        return this.data[this.data.length - 1 - index];
    }

    public float set(int index, float newValue) {
        this.data[index] = newValue;
        return this.data[index];
    }

    public float offset(int index, float offset) {
        int n = index;
        float f = this.data[n] + offset;
        this.data[n] = f;
        return f;
    }

    public float lastSet(int index, float newValue) {
        float f = newValue;
        this.data[this.data.length - 1 - index] = f;
        return f;
    }

    public int hashCode() {
        int hashCode = 0;
        for (float element : this.data) {
            hashCode = (int)((float)(31 * hashCode) + element);
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FloatArray)) {
            return false;
        }
        FloatArray array = (FloatArray)o;
        if (this.data == array.data) {
            return true;
        }
        if (array.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == array.data[i]) continue;
            return false;
        }
        return true;
    }

    public FloatArray clone() {
        return new FloatArray(Arrays.copyOf(this.data, this.data.length));
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public int argmax() {
        if (this.data.length == 0) {
            return -1;
        }
        float element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (!(element < this.data[i])) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.data.length == 0) {
            return -1;
        }
        float element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (!(element > this.data[i])) continue;
            index = i;
        }
        return index;
    }

    public float max() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        float maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (!(maxValue < this.data[i])) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public float sum() {
        float sum = 0.0f;
        for (float element : this.data) {
            sum += element;
        }
        return sum;
    }

    public float min() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        float maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (!(maxValue > this.data[i])) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public boolean all(IFloatFilter rule) {
        for (float datum : this.data) {
            if (rule.filter(datum)) continue;
            return false;
        }
        return true;
    }

    public boolean any(IFloatFilter rule) {
        for (float datum : this.data) {
            if (!rule.filter(datum)) continue;
            return true;
        }
        return false;
    }

    public int count(IFloatFilter rule) {
        int count = 0;
        for (float datum : this.data) {
            if (!rule.filter(datum)) continue;
            ++count;
        }
        return count;
    }

    public TFloatSet toSet() {
        return new TFloatHashSet(this.data);
    }

    public TFloatSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(IFloatFilter function) {
        return new IndexIterator(this.data.length, function == null ? null : index -> function.filter(this.get(index)));
    }

    public void apply(TFloatFunction function) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = function.execute(this.data[i]);
        }
    }

    public void sort() {
        Arrays.sort(this.data);
    }

    public int indexOf(float element) {
        for (int i = 0; i < this.data.length; ++i) {
            if (element != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(IFloatFilter condition) {
        if (condition == null) {
            return -1;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!condition.filter(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString(String joiner) {
        return List.wrap(joiner).toString(joiner);
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.data.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            float temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
    }

    public FloatArray asUnmodifiable() {
        return new FloatArray(this.data){

            @Override
            public boolean setLength(int length) {
                if (length != this.length()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public boolean ensureIndex(int index) {
                if (this.data.length <= index) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public void fill(float value) {
                int l = this.length();
                for (int i = 0; i < l; ++i) {
                    if (this.get(i) == value) continue;
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public float set(int index, float newValue) {
                if (this.get(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public float offset(int index, float offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public float lastSet(int index, float newValue) {
                if (this.lastGet(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public void sort() {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public void shuffle(long seed) {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public FloatArray asUnmodifiable() {
                return this;
            }
        };
    }

    public TFloatIterator iterator() {
        return new TFloatIterator(){
            int pointer = 0;

            @Override
            public float next() {
                return FloatArray.this.get(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < FloatArray.this.length();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }
}

