/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.array;

import edu.sysu.pmglab.ccf.toolkit.filter.IIntFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import gnu.trove.TCollections;
import gnu.trove.function.TIntFunction;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class IntArray {
    int[] data;

    public IntArray(int size) {
        this.data = size == 0 ? EmptyArray.INT : new int[size];
    }

    public IntArray(int[] array) {
        Assert.that(array != null);
        this.data = array.length == 0 ? EmptyArray.INT : array;
    }

    public boolean setLength(int length) {
        if (length == 0) {
            if (this.data != EmptyArray.INT) {
                this.data = EmptyArray.INT;
                return true;
            }
        } else if (this.data.length != length) {
            this.data = Arrays.copyOf(this.data, length);
            return true;
        }
        return false;
    }

    public boolean ensureIndex(int index) {
        if (this.data.length <= index) {
            this.data = Arrays.copyOf(this.data, index + 1);
            return true;
        }
        return false;
    }

    public boolean ensureIndex(int index, int fillValue) {
        if (fillValue == 0) {
            return this.ensureIndex(index);
        }
        if (this.data.length <= index) {
            int oldLength = this.data.length;
            this.data = Arrays.copyOf(this.data, index + 1);
            for (int i = oldLength; i < this.data.length; ++i) {
                this.data[i] = fillValue;
            }
            return true;
        }
        return false;
    }

    public void fill(int value) {
        Arrays.fill(this.data, value);
    }

    public void fill(int from, int to, int value) {
        Arrays.fill(this.data, from, to, value);
    }

    public int[] getData() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public boolean contains(int element) {
        for (int datum : this.data) {
            if (element != datum) continue;
            return true;
        }
        return false;
    }

    public IntArray subArray(int fromIndex, int toIndex) {
        return new IntArray(Arrays.copyOfRange(this.data, fromIndex, toIndex));
    }

    public int get(int index) {
        return this.data[index];
    }

    public int lastGet(int index) {
        return this.data[this.data.length - 1 - index];
    }

    public int set(int index, int newValue) {
        this.data[index] = newValue;
        return this.data[index];
    }

    public int offset(int index, int offset) {
        int n = index;
        int n2 = this.data[n] + offset;
        this.data[n] = n2;
        return n2;
    }

    public int lastSet(int index, int newValue) {
        int n = newValue;
        this.data[this.data.length - 1 - index] = n;
        return n;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int element : this.data) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof IntArray)) {
            return false;
        }
        IntArray array = (IntArray)o;
        if (this.data == array.data) {
            return true;
        }
        if (array.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == array.data[i]) continue;
            return false;
        }
        return true;
    }

    public IntArray clone() {
        return new IntArray(Arrays.copyOf(this.data, this.data.length));
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public int argmax() {
        if (this.data.length == 0) {
            return -1;
        }
        int element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (element >= this.data[i]) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.data.length == 0) {
            return -1;
        }
        int element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (element <= this.data[i]) continue;
            index = i;
        }
        return index;
    }

    public int max() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        int maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (maxValue >= this.data[i]) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public int sum() {
        int sum = 0;
        for (int element : this.data) {
            sum += element;
        }
        return sum;
    }

    public int min() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        int maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (maxValue <= this.data[i]) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public boolean all(IIntFilter rule) {
        for (int datum : this.data) {
            if (rule.filter(datum)) continue;
            return false;
        }
        return true;
    }

    public boolean any(IIntFilter rule) {
        for (int datum : this.data) {
            if (!rule.filter(datum)) continue;
            return true;
        }
        return false;
    }

    public int count(IIntFilter rule) {
        int count = 0;
        for (int datum : this.data) {
            if (!rule.filter(datum)) continue;
            ++count;
        }
        return count;
    }

    public TIntSet toSet() {
        return new TIntHashSet(this.data);
    }

    public TIntSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(IIntFilter function) {
        return new IndexIterator(this.data.length, function == null ? null : index -> function.filter(this.get(index)));
    }

    public void apply(TIntFunction function) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = function.execute(this.data[i]);
        }
    }

    public void sort() {
        Arrays.sort(this.data);
    }

    public int indexOf(int element) {
        for (int i = 0; i < this.data.length; ++i) {
            if (element != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(IIntFilter condition) {
        if (condition == null) {
            return -1;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!condition.filter(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString(String joiner) {
        return List.wrap(joiner).toString(joiner);
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.data.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            int temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
    }

    public IntArray asUnmodifiable() {
        return new IntArray(this.data){

            @Override
            public boolean setLength(int length) {
                if (length != this.length()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public boolean ensureIndex(int index) {
                if (this.data.length <= index) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public void fill(int value) {
                int l = this.length();
                for (int i = 0; i < l; ++i) {
                    if (this.get(i) == value) continue;
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public int set(int index, int newValue) {
                if (this.get(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public int offset(int index, int offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int lastSet(int index, int newValue) {
                if (this.lastGet(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public void sort() {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public void shuffle(long seed) {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public IntArray asUnmodifiable() {
                return this;
            }
        };
    }

    public TIntIterator iterator() {
        return new TIntIterator(){
            int pointer = 0;

            @Override
            public int next() {
                return IntArray.this.get(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < IntArray.this.length();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }
}

