/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.array;

import edu.sysu.pmglab.ccf.toolkit.filter.ILongFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import gnu.trove.TCollections;
import gnu.trove.function.TLongFunction;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class LongArray {
    long[] data;

    public LongArray(int size) {
        this.data = size == 0 ? EmptyArray.LONG : new long[size];
    }

    public LongArray(long[] array) {
        Assert.that(array != null);
        this.data = array.length == 0 ? EmptyArray.LONG : array;
    }

    public boolean setLength(int length) {
        if (length == 0) {
            if (this.data != EmptyArray.LONG) {
                this.data = EmptyArray.LONG;
                return true;
            }
        } else if (this.data.length != length) {
            this.data = Arrays.copyOf(this.data, length);
            return true;
        }
        return false;
    }

    public boolean ensureIndex(int index) {
        if (this.data.length <= index) {
            this.data = Arrays.copyOf(this.data, index + 1);
            return true;
        }
        return false;
    }

    public void fill(long value) {
        Arrays.fill(this.data, value);
    }

    public long[] getData() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public boolean contains(long element) {
        for (long datum : this.data) {
            if (element != datum) continue;
            return true;
        }
        return false;
    }

    public LongArray subArray(int fromIndex, int toIndex) {
        return new LongArray(Arrays.copyOfRange(this.data, fromIndex, toIndex));
    }

    public long get(int index) {
        return this.data[index];
    }

    public long lastGet(int index) {
        return this.data[this.data.length - 1 - index];
    }

    public long set(int index, long newValue) {
        this.data[index] = newValue;
        return this.data[index];
    }

    public long offset(int index, long offset) {
        int n = index;
        long l = this.data[n] + offset;
        this.data[n] = l;
        return l;
    }

    public long lastSet(int index, long newValue) {
        long l = newValue;
        this.data[this.data.length - 1 - index] = l;
        return l;
    }

    public int hashCode() {
        int hashCode = 0;
        for (long element : this.data) {
            hashCode = (int)((long)(31 * hashCode) + element);
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LongArray)) {
            return false;
        }
        LongArray array = (LongArray)o;
        if (this.data == array.data) {
            return true;
        }
        if (array.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == array.data[i]) continue;
            return false;
        }
        return true;
    }

    public LongArray clone() {
        return new LongArray(Arrays.copyOf(this.data, this.data.length));
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public int argmax() {
        if (this.data.length == 0) {
            return -1;
        }
        long element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (element >= this.data[i]) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.data.length == 0) {
            return -1;
        }
        long element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (element <= this.data[i]) continue;
            index = i;
        }
        return index;
    }

    public long max() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        long maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (maxValue >= this.data[i]) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public long sum() {
        long sum = 0L;
        for (long element : this.data) {
            sum += element;
        }
        return sum;
    }

    public long min() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        long maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (maxValue <= this.data[i]) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public boolean all(ILongFilter rule) {
        for (long datum : this.data) {
            if (rule.filter(datum)) continue;
            return false;
        }
        return true;
    }

    public boolean any(ILongFilter rule) {
        for (long datum : this.data) {
            if (!rule.filter(datum)) continue;
            return true;
        }
        return false;
    }

    public int count(ILongFilter rule) {
        int count = 0;
        for (long datum : this.data) {
            if (!rule.filter(datum)) continue;
            ++count;
        }
        return count;
    }

    public TLongSet toSet() {
        return new TLongHashSet(this.data);
    }

    public TLongSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(ILongFilter function) {
        return new IndexIterator(this.data.length, function == null ? null : index -> function.filter(this.get(index)));
    }

    public void apply(TLongFunction function) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = function.execute(this.data[i]);
        }
    }

    public void sort() {
        Arrays.sort(this.data);
    }

    public int indexOf(long element) {
        for (int i = 0; i < this.data.length; ++i) {
            if (element != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(ILongFilter condition) {
        if (condition == null) {
            return -1;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!condition.filter(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString(String joiner) {
        return List.wrap(joiner).toString(joiner);
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.data.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            long temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
    }

    public LongArray asUnmodifiable() {
        return new LongArray(this.data){

            @Override
            public boolean setLength(int length) {
                if (length != this.length()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public boolean ensureIndex(int index) {
                if (this.data.length <= index) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public void fill(long value) {
                int l = this.length();
                for (int i = 0; i < l; ++i) {
                    if (this.get(i) == value) continue;
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public long set(int index, long newValue) {
                if (this.get(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public long offset(int index, long offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long lastSet(int index, long newValue) {
                if (this.lastGet(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public void sort() {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public void shuffle(long seed) {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public LongArray asUnmodifiable() {
                return this;
            }
        };
    }

    public TLongIterator iterator() {
        return new TLongIterator(){
            int pointer = 0;

            @Override
            public long next() {
                return LongArray.this.get(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < LongArray.this.length();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }
}

