/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.array;

import edu.sysu.pmglab.ccf.toolkit.filter.IShortFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import gnu.trove.TCollections;
import gnu.trove.function.TShortFunction;
import gnu.trove.iterator.TShortIterator;
import gnu.trove.set.TShortSet;
import gnu.trove.set.hash.TShortHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class ShortArray {
    short[] data;

    public ShortArray(int size) {
        this.data = size == 0 ? EmptyArray.SHORT : new short[size];
    }

    public ShortArray(short[] array) {
        Assert.that(array != null);
        this.data = array.length == 0 ? EmptyArray.SHORT : array;
    }

    public boolean setLength(int length) {
        if (length == 0) {
            if (this.data != EmptyArray.SHORT) {
                this.data = EmptyArray.SHORT;
                return true;
            }
        } else if (this.data.length != length) {
            this.data = Arrays.copyOf(this.data, length);
            return true;
        }
        return false;
    }

    public boolean ensureIndex(int index) {
        if (this.data.length <= index) {
            this.data = Arrays.copyOf(this.data, index + 1);
            return true;
        }
        return false;
    }

    public void fill(short value) {
        Arrays.fill(this.data, value);
    }

    public short[] getData() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public boolean contains(short element) {
        for (short datum : this.data) {
            if (element != datum) continue;
            return true;
        }
        return false;
    }

    public ShortArray subArray(int fromIndex, int toIndex) {
        return new ShortArray(Arrays.copyOfRange(this.data, fromIndex, toIndex));
    }

    public short get(int index) {
        return this.data[index];
    }

    public short lastGet(int index) {
        return this.data[this.data.length - 1 - index];
    }

    public short set(int index, short newValue) {
        this.data[index] = newValue;
        return this.data[index];
    }

    public short offset(int index, short offset) {
        int n = index;
        short s = (short)(this.data[n] + offset);
        this.data[n] = s;
        return s;
    }

    public short lastSet(int index, short newValue) {
        short s = newValue;
        this.data[this.data.length - 1 - index] = s;
        return s;
    }

    public int hashCode() {
        int hashCode = 0;
        for (short element : this.data) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ShortArray)) {
            return false;
        }
        ShortArray array = (ShortArray)o;
        if (this.data == array.data) {
            return true;
        }
        if (array.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == array.data[i]) continue;
            return false;
        }
        return true;
    }

    public ShortArray clone() {
        return new ShortArray(Arrays.copyOf(this.data, this.data.length));
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public int argmax() {
        if (this.data.length == 0) {
            return -1;
        }
        short element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (element >= this.data[i]) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.data.length == 0) {
            return -1;
        }
        short element = this.data[0];
        int index = 0;
        for (int i = 1; i < this.data.length; ++i) {
            if (element <= this.data[i]) continue;
            index = i;
        }
        return index;
    }

    public short max() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        short maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (maxValue >= this.data[i]) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public short sum() {
        short sum = 0;
        for (short element : this.data) {
            sum = (short)(sum + element);
        }
        return sum;
    }

    public short min() {
        if (this.data.length == 0) {
            throw new NoSuchElementException();
        }
        short maxValue = this.data[0];
        int l = this.data.length;
        for (int i = 1; i < l; ++i) {
            if (maxValue <= this.data[i]) continue;
            maxValue = this.data[i];
        }
        return maxValue;
    }

    public boolean all(IShortFilter rule) {
        for (short datum : this.data) {
            if (rule.filter(datum)) continue;
            return false;
        }
        return true;
    }

    public boolean any(IShortFilter rule) {
        for (short datum : this.data) {
            if (!rule.filter(datum)) continue;
            return true;
        }
        return false;
    }

    public int count(IShortFilter rule) {
        int count = 0;
        for (short datum : this.data) {
            if (!rule.filter(datum)) continue;
            ++count;
        }
        return count;
    }

    public TShortSet toSet() {
        return new TShortHashSet(this.data);
    }

    public TShortSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(IShortFilter function) {
        return new IndexIterator(this.data.length, function == null ? null : index -> function.filter(this.get(index)));
    }

    public void apply(TShortFunction function) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = function.execute(this.data[i]);
        }
    }

    public void sort() {
        Arrays.sort(this.data);
    }

    public int indexOf(short element) {
        for (int i = 0; i < this.data.length; ++i) {
            if (element != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(IShortFilter condition) {
        if (condition == null) {
            return -1;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!condition.filter(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString(String joiner) {
        return List.wrap(joiner).toString(joiner);
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.data.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            short temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
    }

    public ShortArray asUnmodifiable() {
        return new ShortArray(this.data){

            @Override
            public boolean setLength(int length) {
                if (length != this.length()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public boolean ensureIndex(int index) {
                if (this.data.length <= index) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public void fill(short value) {
                int l = this.length();
                for (int i = 0; i < l; ++i) {
                    if (this.get(i) == value) continue;
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public short set(int index, short newValue) {
                if (this.get(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public short offset(int index, short offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public short lastSet(int index, short newValue) {
                if (this.lastGet(index) != newValue) {
                    throw new UnsupportedOperationException();
                }
                return newValue;
            }

            @Override
            public void sort() {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public void shuffle(long seed) {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public ShortArray asUnmodifiable() {
                return this;
            }
        };
    }

    public TShortIterator iterator() {
        return new TShortIterator(){
            int pointer = 0;

            @Override
            public short next() {
                return ShortArray.this.get(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < ShortArray.this.length();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }
}

