/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.array;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.iterator.FilterIterator;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

public class StringArray
implements Iterable<String> {
    String[] data;

    public StringArray(int size) {
        this.data = size == 0 ? EmptyArray.STRING : new String[size];
    }

    public StringArray(String ... array) {
        Assert.that(array != null);
        this.data = array.length == 0 ? EmptyArray.STRING : array;
    }

    public boolean setLength(int length) {
        if (length == 0) {
            if (this.data != EmptyArray.STRING) {
                this.data = EmptyArray.STRING;
                return true;
            }
        } else if (this.data.length != length) {
            this.data = Arrays.copyOf(this.data, length);
            return true;
        }
        return false;
    }

    public boolean ensureIndex(int index) {
        if (this.data.length <= index) {
            this.data = Arrays.copyOf(this.data, index + 1);
            return true;
        }
        return false;
    }

    public void fill(String value) {
        Arrays.fill(this.data, value);
    }

    public String[] getData() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public boolean contains(String element) {
        if (element == null) {
            for (String datum : this.data) {
                if (null != datum) continue;
                return true;
            }
        } else {
            for (String datum : this.data) {
                if (!element.equals(datum)) continue;
                return true;
            }
        }
        return false;
    }

    public StringArray subArray(int fromIndex, int toIndex) {
        return new StringArray(Arrays.copyOfRange(this.data, fromIndex, toIndex));
    }

    public String get(int index) {
        return this.data[index];
    }

    public String lastGet(int index) {
        return this.data[this.data.length - 1 - index];
    }

    public String set(int index, String newValue) {
        this.data[index] = newValue;
        return this.data[index];
    }

    public String lastSet(int index, String newValue) {
        String string = newValue;
        this.data[this.data.length - 1 - index] = string;
        return string;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof StringArray)) {
            return false;
        }
        StringArray array = (StringArray)o;
        if (this.data == array.data) {
            return true;
        }
        if (array.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (Objects.equals(this.data[i], array.data[i])) continue;
            return false;
        }
        return true;
    }

    public StringArray clone() {
        return new StringArray(Arrays.copyOf(this.data, this.data.length));
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public boolean all(IFilter<String> rule) {
        for (String datum : this.data) {
            if (rule.filter(datum)) continue;
            return false;
        }
        return true;
    }

    public boolean any(IFilter<String> rule) {
        for (String datum : this.data) {
            if (!rule.filter(datum)) continue;
            return true;
        }
        return false;
    }

    public int count(IFilter<String> rule) {
        int count = 0;
        for (String datum : this.data) {
            if (!rule.filter(datum)) continue;
            ++count;
        }
        return count;
    }

    public IndexableSet<String> toSet() {
        LinkedSet<String> values2 = new LinkedSet<String>(this.data.length);
        for (String datum : this.data) {
            values2.add(datum);
        }
        return values2;
    }

    public IndexIterator where(IFilter<String> function) {
        return new IndexIterator(this.data.length, function == null ? null : index -> function.filter(this.get(index)));
    }

    public void apply(Function<String, String> function) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = function.apply(this.data[i]);
        }
    }

    public int indexOf(String element) {
        if (element == null) {
            for (int i = 0; i < this.data.length; ++i) {
                if (null != this.data[i]) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                if (!element.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfIf(IFilter<String> condition) {
        if (condition == null) {
            return -1;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!condition.filter(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString(String joiner) {
        return List.wrap(joiner).toString(joiner);
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.data.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            String temp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = temp;
        }
    }

    public StringArray asUnmodifiable() {
        return new StringArray(this.data){

            @Override
            public boolean setLength(int length) {
                if (length != this.length()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public boolean ensureIndex(int index) {
                if (this.data.length <= index) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }

            @Override
            public void fill(String value) {
                if (this.length() >= 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public String set(int index, String newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String lastSet(int index, String newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void shuffle(long seed) {
                if (this.length() > 1) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public StringArray asUnmodifiable() {
                return this;
            }
        };
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int pointer = 0;

            @Override
            public boolean hasNext() {
                return this.pointer < StringArray.this.length();
            }

            @Override
            public String next() {
                return StringArray.this.get(this.pointer++);
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator<String> filter(IFilter<String> filter) {
        return new FilterIterator<String>(this, filter);
    }
}

