/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.bits;

public abstract class Bits {
    final int nbits;
    int bitStart = -1;
    int bitEnd = -1;

    public Bits(int nbits) {
        this.nbits = nbits;
    }

    final void checkIndex(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        if (bitIndex >= this.nbits) {
            throw new IndexOutOfBoundsException("bitIndex >= " + this.nbits + " (bits): " + bitIndex);
        }
    }

    final void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        if (fromIndex >= this.nbits) {
            throw new IndexOutOfBoundsException("fromIndex >= " + this.nbits + " (bits): " + fromIndex);
        }
        if (toIndex > this.nbits) {
            throw new IndexOutOfBoundsException("toIndex > " + this.nbits + " (bits): " + toIndex);
        }
    }

    abstract int bitPosition(int var1);

    abstract int wordIndex(int var1);

    public abstract Bits clear();

    public abstract Bits set(int var1);

    public abstract Bits set(int var1, int var2);

    public abstract boolean get(int var1);

    public final int nBits() {
        return this.nbits;
    }

    public abstract int nWords();

    public final int bitStart() {
        return this.bitStart;
    }

    public final int bitEnd() {
        return this.bitEnd;
    }

    public abstract int nextSetBit(int var1);

    public abstract Bits clone();

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.nbits; ++i) {
            if (this.get(i)) {
                builder.append(1);
                continue;
            }
            builder.append(0);
        }
        return builder.toString();
    }

    public final int wordStart() {
        return this.bitStart == -1 ? -1 : this.wordIndex(this.bitStart);
    }

    public final int wordEnd() {
        return this.bitEnd == -1 ? -1 : this.wordIndex(this.bitEnd);
    }
}

