/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.bits;

import edu.sysu.pmglab.container.bits.Bits;
import java.util.Arrays;

public class IntBits
extends Bits {
    private static final int ADDRESS_BITS_PER_WORD = 5;
    private static final int BITS_PER_WORD = 32;
    private static final int BIT_INDEX_MASK = 31;
    private static final int WORD_MASK = -1;
    private final int[] words;

    public IntBits(int nbits) {
        super(nbits);
        this.words = new int[this.wordIndex(nbits - 1) + 1];
    }

    public IntBits(int[] words, int nbits, int bitStart, int bitEnd) {
        super(nbits);
        this.words = words;
        this.bitStart = bitStart;
        this.bitEnd = bitEnd;
    }

    @Override
    int bitPosition(int bitIndex) {
        return bitIndex & 0x1F;
    }

    @Override
    int wordIndex(int bitIndex) {
        return bitIndex >> 5;
    }

    @Override
    public IntBits clear() {
        if (this.bitStart != -1) {
            int wordStart = this.wordIndex(this.bitStart);
            int wordEnd = this.wordIndex(this.bitEnd);
            for (int i = wordStart; i <= wordEnd; ++i) {
                this.words[i] = 0;
            }
            this.bitStart = -1;
            this.bitEnd = -1;
        }
        return this;
    }

    @Override
    public IntBits set(int bitIndex) {
        this.checkIndex(bitIndex);
        int wordIndex = this.wordIndex(bitIndex);
        int bitPosition = this.bitPosition(bitIndex);
        if (this.words[wordIndex] != -1) {
            int n = wordIndex;
            this.words[n] = this.words[n] | 1 << bitPosition;
            if (this.bitStart == -1) {
                this.bitStart = bitIndex;
                this.bitEnd = bitIndex;
            } else if (this.bitStart > bitIndex) {
                this.bitStart = bitIndex;
            } else if (this.bitEnd < bitIndex) {
                this.bitEnd = bitIndex;
            }
        }
        return this;
    }

    @Override
    public IntBits set(int fromIndex, int toIndex) {
        this.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return this;
        }
        int wordStartIndex = this.wordIndex(fromIndex);
        int wordEndIndex = this.wordIndex(toIndex - 1);
        int firstWordMask = -1 << this.bitPosition(fromIndex);
        int lastWordMask = -1 >>> -this.bitPosition(toIndex);
        if (wordStartIndex == wordEndIndex) {
            int n = wordStartIndex;
            this.words[n] = this.words[n] | firstWordMask & lastWordMask;
        } else {
            int n = wordStartIndex;
            this.words[n] = this.words[n] | firstWordMask;
            for (int i = wordStartIndex + 1; i < wordEndIndex; ++i) {
                this.words[i] = -1;
            }
            int n2 = wordEndIndex;
            this.words[n2] = this.words[n2] | lastWordMask;
        }
        if (this.bitStart == -1) {
            this.bitStart = fromIndex;
            this.bitEnd = toIndex - 1;
        } else {
            if (this.bitStart > fromIndex) {
                this.bitStart = fromIndex;
            }
            if (this.bitEnd < toIndex - 1) {
                this.bitEnd = toIndex - 1;
            }
        }
        return this;
    }

    @Override
    public boolean get(int bitIndex) {
        this.checkIndex(bitIndex);
        if (this.bitStart == -1) {
            return false;
        }
        if (this.bitStart <= bitIndex && this.bitEnd >= bitIndex) {
            int bitPosition;
            int wordIndex = this.wordIndex(bitIndex);
            return (this.words[wordIndex] & 1 << (bitPosition = this.bitPosition(bitIndex))) != 0;
        }
        return false;
    }

    @Override
    public int nWords() {
        return this.words.length;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + fromIndex);
        }
        if (this.bitStart == -1) {
            return -1;
        }
        if (fromIndex < this.bitStart) {
            return this.bitStart;
        }
        if (fromIndex >= this.bitEnd) {
            if (fromIndex == this.bitEnd) {
                return fromIndex;
            }
            return -1;
        }
        int wordIndex = this.wordIndex(fromIndex);
        int bitPosition = this.bitPosition(fromIndex);
        int wordEndIndex = this.wordIndex(this.bitEnd);
        int word = this.words[wordIndex] & -1 << bitPosition;
        if (word != 0) {
            return wordIndex << 5 | Integer.numberOfTrailingZeros(word);
        }
        ++wordIndex;
        while (wordIndex <= wordEndIndex) {
            word = this.words[wordIndex] & 0xFFFFFFFF;
            if (word != 0) {
                return wordIndex << 5 | Integer.numberOfTrailingZeros(word);
            }
            ++wordIndex;
        }
        return -1;
    }

    public int getWord(int wordIndex) {
        return this.words[wordIndex];
    }

    public int[] getWords() {
        return this.words;
    }

    @Override
    public IntBits clone() {
        return new IntBits(Arrays.copyOf(this.words, this.words.length), this.nbits, this.bitStart, this.bitEnd);
    }
}

