/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.bits;

import edu.sysu.pmglab.container.bits.Bits;
import java.util.Arrays;

public class LongBits
extends Bits {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private final long[] words;

    public LongBits(int nbits) {
        super(nbits);
        this.words = new long[this.wordIndex(nbits - 1) + 1];
    }

    public LongBits(long[] words, int nbits) {
        super(nbits);
        this.words = words;
        int length = this.wordIndex(nbits - 1) + 1;
        if (length != words.length) {
            throw new IllegalArgumentException();
        }
        this.bitStart = 0;
        this.bitEnd = nbits - 1;
    }

    public LongBits(long[] words, int nbits, int bitStart, int bitEnd) {
        super(nbits);
        int length = this.wordIndex(nbits - 1) + 1;
        if (length != words.length || bitStart > bitEnd || bitStart == -1 && bitEnd != -1 || bitStart != -1 && bitEnd == -1 || bitStart >= nbits || bitEnd >= nbits) {
            throw new IllegalArgumentException();
        }
        this.words = words;
        this.bitStart = bitStart;
        this.bitEnd = bitEnd;
        if (!(this.bitStart == -1 || this.get(this.bitStart) && this.get(this.bitEnd))) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    int bitPosition(int bitIndex) {
        return bitIndex & 0x3F;
    }

    @Override
    int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    @Override
    public LongBits clear() {
        if (this.bitStart != -1) {
            int wordStart = this.wordIndex(this.bitStart);
            int wordEnd = this.wordIndex(this.bitEnd);
            for (int i = wordStart; i <= wordEnd; ++i) {
                this.words[i] = 0L;
            }
            this.bitStart = -1;
            this.bitEnd = -1;
        }
        return this;
    }

    @Override
    public LongBits set(int bitIndex) {
        this.checkIndex(bitIndex);
        int wordIndex = this.wordIndex(bitIndex);
        if (this.words[wordIndex] != -1L) {
            int n = wordIndex;
            this.words[n] = this.words[n] | 1L << bitIndex;
            if (this.bitStart == -1) {
                this.bitStart = bitIndex;
                this.bitEnd = bitIndex;
            } else if (this.bitStart > bitIndex) {
                this.bitStart = bitIndex;
            } else if (this.bitEnd < bitIndex) {
                this.bitEnd = bitIndex;
            }
        }
        return this;
    }

    @Override
    public LongBits set(int fromIndex, int toIndex) {
        this.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return this;
        }
        int wordStartIndex = this.wordIndex(fromIndex);
        int wordEndIndex = this.wordIndex(toIndex - 1);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (wordStartIndex == wordEndIndex) {
            int n = wordStartIndex;
            this.words[n] = this.words[n] | firstWordMask & lastWordMask;
        } else {
            int n = wordStartIndex;
            this.words[n] = this.words[n] | firstWordMask;
            for (int i = wordStartIndex + 1; i < wordEndIndex; ++i) {
                this.words[i] = -1L;
            }
            int n2 = wordEndIndex;
            this.words[n2] = this.words[n2] | lastWordMask;
        }
        if (this.bitStart == -1) {
            this.bitStart = fromIndex;
            this.bitEnd = toIndex - 1;
        } else {
            if (this.bitStart > fromIndex) {
                this.bitStart = fromIndex;
            }
            if (this.bitEnd < toIndex - 1) {
                this.bitEnd = toIndex - 1;
            }
        }
        return this;
    }

    @Override
    public boolean get(int bitIndex) {
        this.checkIndex(bitIndex);
        if (this.bitStart == -1) {
            return false;
        }
        if (this.bitStart <= bitIndex && this.bitEnd >= bitIndex) {
            int bitPosition;
            int wordIndex = this.wordIndex(bitIndex);
            return (this.words[wordIndex] & 1L << (bitPosition = this.bitPosition(bitIndex))) != 0L;
        }
        return false;
    }

    @Override
    public int nWords() {
        return this.words.length;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + fromIndex);
        }
        if (this.bitStart == -1) {
            return -1;
        }
        if (fromIndex < this.bitStart) {
            return this.bitStart;
        }
        if (fromIndex >= this.bitEnd) {
            if (fromIndex == this.bitEnd) {
                return fromIndex;
            }
            return -1;
        }
        int wordIndex = this.wordIndex(fromIndex);
        int bitPosition = this.bitPosition(fromIndex);
        int wordEndIndex = this.wordIndex(this.bitEnd);
        long word = this.words[wordIndex] & -1L << fromIndex;
        if (word != 0L) {
            return wordIndex << 6 | Long.numberOfTrailingZeros(word);
        }
        ++wordIndex;
        while (wordIndex <= wordEndIndex) {
            word = this.words[wordIndex] & 0xFFFFFFFFFFFFFFFFL;
            if (word != 0L) {
                return wordIndex << 6 | Long.numberOfTrailingZeros(word);
            }
            ++wordIndex;
        }
        return -1;
    }

    @Override
    public LongBits clone() {
        return new LongBits(Arrays.copyOf(this.words, this.words.length), this.nbits, this.bitStart, this.bitEnd);
    }

    public long getWord(int wordIndex) {
        return this.words[wordIndex];
    }

    public long[] getWords() {
        return this.words;
    }
}

