/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.circle;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CircularArray<T>
implements Iterable<T> {
    private final Object[] buffer;
    private int head = 0;
    private int tail = 0;
    private int size = 0;

    public CircularArray(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than zero.");
        }
        this.buffer = new Object[capacity];
    }

    public void add(T element) {
        this.buffer[this.tail] = element;
        this.tail = (this.tail + 1) % this.buffer.length;
        if (this.size == this.buffer.length) {
            this.head = (this.head + 1) % this.buffer.length;
        } else {
            ++this.size;
        }
    }

    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        return (T)this.buffer[(this.head + index) % this.buffer.length];
    }

    public T popFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("CircularArray is empty.");
        }
        Object element = this.buffer[this.head];
        this.buffer[this.head] = null;
        this.head = (this.head + 1) % this.buffer.length;
        --this.size;
        return (T)element;
    }

    public T popLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("CircularArray is empty.");
        }
        this.tail = (this.tail - 1 + this.buffer.length) % this.buffer.length;
        Object element = this.buffer[this.tail];
        this.buffer[this.tail] = null;
        --this.size;
        return (T)element;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.buffer.length;
    }

    public void clear() {
        Arrays.fill(this.buffer, null);
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.buffer[(this.head + i) % this.buffer.length]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < CircularArray.this.size;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object element = CircularArray.this.buffer[(CircularArray.this.head + this.index) % CircularArray.this.buffer.length];
                ++this.index;
                return element;
            }
        };
    }
}

