/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.circle;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;

public class CircularMap<K, V> {
    private final int capacity;
    private final Object[] keys;
    private final Object[] values;
    private final TObjectIntMap<K> indexMap;
    private int size = 0;
    private int head = 0;
    private int tail = 0;

    public CircularMap(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than zero.");
        }
        this.capacity = capacity;
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        this.indexMap = new TObjectIntHashMap(capacity, 0.5f, -1);
    }

    public void put(K key, V value) {
        if (this.indexMap.containsKey(key)) {
            int idx = this.indexMap.get(key);
            this.values[idx] = value;
            return;
        }
        if (this.size == this.capacity) {
            Object oldKey = this.keys[this.head];
            this.indexMap.remove(oldKey);
            this.head = (this.head + 1) % this.capacity;
        } else {
            ++this.size;
        }
        this.keys[this.tail] = key;
        this.values[this.tail] = value;
        this.indexMap.put(key, this.tail);
        this.tail = (this.tail + 1) % this.capacity;
    }

    public V get(K key) {
        int idx = this.indexMap.get(key);
        if (idx == -1) {
            return null;
        }
        return (V)this.values[idx];
    }

    public boolean containsKey(K key) {
        return this.indexMap.containsKey(key);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.keys.length;
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
        this.indexMap.clear();
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.size; ++i) {
            int pos = (this.head + i) % this.capacity;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.keys[pos]).append("=").append(this.values[pos]);
        }
        sb.append("}");
        return sb.toString();
    }
}

