/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.circle;

import edu.sysu.pmglab.container.circle.CircularMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentCircularMap<K, V>
extends CircularMap<K, V> {
    private final ReadWriteLock LOCK = new ReentrantReadWriteLock();

    public ConcurrentCircularMap(int capacity) {
        super(capacity);
    }

    @Override
    public void put(K key, V value) {
        this.LOCK.writeLock().lock();
        try {
            super.put(key, value);
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    @Override
    public V get(K key) {
        this.LOCK.readLock().lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.LOCK.readLock().unlock();
        }
    }

    @Override
    public boolean containsKey(K key) {
        this.LOCK.readLock().lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.LOCK.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.LOCK.readLock().lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.LOCK.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.LOCK.writeLock().lock();
        try {
            super.clear();
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }
}

