/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.indexable;

import edu.sysu.pmglab.container.indexable.LinkedSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentLinkedSet<V>
extends LinkedSet<V> {
    private final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private volatile int size = 0;

    public ConcurrentLinkedSet() {
        this(4);
    }

    public ConcurrentLinkedSet(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentLinkedSet(V[] values2) {
        super(values2);
    }

    public ConcurrentLinkedSet(Iterable<V> values2) {
        super(values2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object value) {
        int fastIndex = this.indexes.get(value);
        if (fastIndex != -1) {
            return fastIndex;
        }
        this.LOCK.readLock().lock();
        try {
            int n = this.indexes.get(value);
            return n;
        }
        finally {
            this.LOCK.readLock().unlock();
        }
    }

    @Override
    public V valueOf(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (index < this.size) {
            return (V)this.values.get(index);
        }
        this.LOCK.readLock().lock();
        try {
            Object t = this.values.get(index);
            return (V)t;
        }
        finally {
            this.LOCK.readLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (this.indexes.containsKey(o)) {
            return true;
        }
        this.LOCK.readLock().lock();
        try {
            boolean bl = this.indexes.containsKey(o);
            return bl;
        }
        finally {
            this.LOCK.readLock().unlock();
        }
    }

    @Override
    public boolean add(V value) {
        this.LOCK.writeLock().lock();
        try {
            super.add(value);
            this.size = this.values.size();
            boolean bl = true;
            return bl;
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.LOCK.writeLock().lock();
        try {
            super.clear();
            this.size = 0;
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }
}

