/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.indexable;

import edu.sysu.pmglab.container.indexable.IndexableMap;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class DynamicIndexableMap<K, V>
extends IndexableMap<K, V> {
    final IndexableSet<K> keys;
    final TIntObjectHashMap<V> values;

    public DynamicIndexableMap() {
        this(4);
    }

    public DynamicIndexableMap(int initialCapacity) {
        this.keys = new LinkedSet<K>(initialCapacity);
        this.values = new TIntObjectHashMap(initialCapacity);
    }

    public DynamicIndexableMap(IndexableSet<K> keys2) {
        this.keys = keys2;
        this.values = new TIntObjectHashMap(4);
    }

    @Override
    public V putByIndex(int keyIndex, V value) {
        if (keyIndex < 0 || keyIndex >= this.keys.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(keyIndex));
        }
        this.values.put(keyIndex, value);
        return value;
    }

    @Override
    public V putByIndexIfAbsent(int keyIndex, V value) {
        if (keyIndex < 0 || keyIndex >= this.keys.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(keyIndex));
        }
        return this.values.putIfAbsent(keyIndex, value);
    }

    @Override
    public V getByIndex(int index) {
        return this.values.get(index);
    }

    @Override
    public V getByIndexOrDefault(int keyIndex, V defaultValue) {
        if (this.values.containsKey(keyIndex)) {
            return this.values.get(keyIndex);
        }
        return defaultValue;
    }

    @Override
    public V removeByIndex(int keyIndex) {
        return this.values.remove(keyIndex);
    }

    @Override
    public int indexOfKey(K key) {
        return this.keys.indexOf(key);
    }

    @Override
    public K keyOfIndex(int keyIndex) {
        return this.keys.valueOf(keyIndex);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.keys.indexOf(key);
        return index != -1 && this.values.containsKey(index);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public V get(Object key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return null;
        }
        return this.getByIndex(index);
    }

    @Override
    public V put(K key, V value) {
        int keyIndex = this.keys.indexOf(key);
        if (keyIndex == -1) {
            this.keys.add(key);
            keyIndex = this.keys.indexOf(key);
        }
        return this.values.put(keyIndex, value);
    }

    @Override
    public V remove(Object key) {
        return this.values.remove(this.indexOfKey(key));
    }

    @Override
    public Set<K> keySet() {
        if (this.values.size() == 0) {
            return Collections.EMPTY_SET;
        }
        if (this.values.size() == this.keys.size()) {
            return this.keys;
        }
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    final TIntIterator iter;
                    {
                        this.iter = DynamicIndexableMap.this.values.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public K next() {
                        return DynamicIndexableMap.this.keys.valueOf(this.iter.next());
                    }
                };
            }

            @Override
            public int size() {
                return DynamicIndexableMap.this.values.size();
            }

            @Override
            public boolean contains(Object o) {
                return DynamicIndexableMap.this.containsKey(o);
            }
        };
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return defaultValue;
        }
        if (this.values.containsKey(index)) {
            return this.values.get(index);
        }
        return defaultValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int keyIndex = this.keys.indexOf(key);
        if (keyIndex == -1) {
            this.keys.add(key);
            keyIndex = this.keys.indexOf(key);
        }
        return this.values.putIfAbsent(keyIndex, value);
    }

    @Override
    public boolean containsKeyIndex(int keyIndex) {
        return this.values.containsKey(keyIndex);
    }

    @Override
    public void clear() {
        this.values.clear();
    }
}

