/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.indexable;

import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.indexable.IndexableMap;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class FixedIndexableMap<K, V>
extends IndexableMap<K, V> {
    final IndexableSet<K> keys;
    final Object[] values;
    final boolean[] status;
    int size = 0;

    public FixedIndexableMap(IndexableSet<K> keys2) {
        if (keys2 == null || keys2.size() == 0) {
            this.keys = IndexableSet.EMPTY();
            this.values = EmptyArray.OBJECT;
            this.status = EmptyArray.BOOLEAN;
        } else {
            this.keys = keys2.asUnmodifiable();
            this.values = new Object[keys2.size()];
            this.status = new boolean[this.values.length];
        }
    }

    public FixedIndexableMap(K[] keys2) {
        this(new LinkedSet<K>(keys2).asUnmodifiable());
    }

    @Override
    public V putByIndex(int keyIndex, V value) {
        if (this.status[keyIndex]) {
            this.values[keyIndex] = value;
        } else {
            this.values[keyIndex] = value;
            this.status[keyIndex] = true;
            ++this.size;
        }
        return value;
    }

    @Override
    public V putByIndexIfAbsent(int keyIndex, V value) {
        if (!this.status[keyIndex]) {
            this.values[keyIndex] = value;
            this.status[keyIndex] = true;
            ++this.size;
        }
        return (V)this.values[keyIndex];
    }

    @Override
    public V getByIndex(int keyIndex) {
        return (V)this.values[keyIndex];
    }

    @Override
    public V getByIndexOrDefault(int keyIndex, V defaultValue) {
        if (this.status[keyIndex]) {
            return (V)this.values[keyIndex];
        }
        return defaultValue;
    }

    @Override
    public V removeByIndex(int keyIndex) {
        Object prev = this.values[keyIndex];
        if (this.status[keyIndex]) {
            this.values[keyIndex] = null;
            this.status[keyIndex] = false;
            --this.size;
        }
        return (V)prev;
    }

    @Override
    public int indexOfKey(K key) {
        return this.keys.indexOf(key);
    }

    @Override
    public K keyOfIndex(int keyIndex) {
        return this.keys.valueOf(keyIndex);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.keys.indexOf(key);
        return index != -1 && this.status[index];
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.size == 0) {
            return false;
        }
        int count = this.size;
        if (value == null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.status[i]) continue;
                if (this.values[i] == null) {
                    return true;
                }
                if (--count != 0) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.status[i]) continue;
                if (value.equals(this.values[i])) {
                    return true;
                }
                if (--count != 0) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return null;
        }
        return (V)this.values[index];
    }

    @Override
    public V put(K key, V value) {
        return this.putByIndex(this.keys.indexOf(key), value);
    }

    @Override
    public V remove(Object key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return null;
        }
        return this.removeByIndex(index);
    }

    @Override
    public Set<K> keySet() {
        if (this.size == 0) {
            return Collections.EMPTY_SET;
        }
        if (this.size == this.keys.size()) {
            return this.keys;
        }
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    final int size;
                    int remaining;
                    int currentIndex;
                    {
                        this.size = FixedIndexableMap.this.status.length;
                        this.remaining = FixedIndexableMap.this.size;
                        this.currentIndex = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.remaining > 0 && this.currentIndex < this.size) {
                            if (FixedIndexableMap.this.status[this.currentIndex]) {
                                return true;
                            }
                            ++this.currentIndex;
                        }
                        return false;
                    }

                    @Override
                    public K next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        --this.remaining;
                        return FixedIndexableMap.this.keys.valueOf(this.currentIndex++);
                    }
                };
            }

            @Override
            public int size() {
                return FixedIndexableMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                return FixedIndexableMap.this.containsKey(o);
            }
        };
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return defaultValue;
        }
        if (this.status[index]) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putByIndexIfAbsent(this.keys.indexOf(key), value);
    }

    @Override
    public boolean containsKeyIndex(int keyIndex) {
        return this.status[keyIndex];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        for (int i = 0; i < this.status.length; ++i) {
            if (!this.status[i]) continue;
            this.values[i] = null;
            this.status[i] = false;
            --this.size;
            if (this.size != 0) continue;
            return;
        }
    }
}

