/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.indexable;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class IndexableMap<K, V>
extends AbstractMap<K, V> {
    private static final IndexableMap<?, ?> EMPTY = new IndexableMap<Object, Object>(){

        @Override
        public Object putByIndex(int keyIndex, Object value) {
            throw new IndexOutOfBoundsException(String.valueOf(keyIndex));
        }

        @Override
        public Object putByIndexIfAbsent(int keyIndex, Object value) {
            throw new IndexOutOfBoundsException(String.valueOf(keyIndex));
        }

        @Override
        public Object getByIndex(int keyIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(keyIndex));
        }

        @Override
        public Object getByIndexOrDefault(int keyIndex, Object defaultValue) {
            throw new IndexOutOfBoundsException(String.valueOf(keyIndex));
        }

        @Override
        public Object removeByIndex(int keyIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(keyIndex));
        }

        @Override
        public int indexOfKey(Object key) {
            return -1;
        }

        @Override
        public Object keyOfIndex(int keyIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(keyIndex));
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object put(Object key, Object value) {
            throw new IndexOutOfBoundsException(String.valueOf("-1"));
        }

        @Override
        public Object remove(Object key) {
            return null;
        }

        @Override
        public Set<Object> keySet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Object getOrDefault(Object key, Object defaultValue) {
            return defaultValue;
        }

        @Override
        public Object putIfAbsent(Object key, Object value) {
            throw new IndexOutOfBoundsException("-1");
        }

        @Override
        public boolean containsKeyIndex(int keyIndex) {
            return false;
        }
    };

    public static <K, V> IndexableMap<K, V> EMPTY() {
        return EMPTY;
    }

    public abstract V putByIndex(int var1, V var2);

    public abstract V putByIndexIfAbsent(int var1, V var2);

    public abstract V getByIndex(int var1);

    public abstract V getByIndexOrDefault(int var1, V var2);

    public abstract V removeByIndex(int var1);

    public abstract int indexOfKey(K var1);

    public abstract K keyOfIndex(int var1);

    @Override
    public abstract int size();

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public abstract boolean containsValue(Object var1);

    @Override
    public abstract boolean containsKey(Object var1);

    @Override
    public abstract V get(Object var1);

    @Override
    public abstract V put(K var1, V var2);

    @Override
    public abstract V remove(Object var1);

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        if (m != null) {
            for (K key : m.keySet()) {
                this.put(key, m.get(key));
            }
        }
    }

    @Override
    public abstract Set<K> keySet();

    @Override
    public final Collection<V> values() {
        ArrayList<V> values2 = new ArrayList<V>(this.size());
        for (K key : this.keySet()) {
            values2.add(this.get(key));
        }
        return Collections.unmodifiableList(values2);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
        for (K key : this.keySet()) {
            entries.add(new AbstractMap.SimpleImmutableEntry<K, V>(key, this.get(key)));
        }
        return entries;
    }

    @Override
    public final String toString() {
        Iterator<K> keys2 = this.keySet().iterator();
        if (!keys2.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            K key = keys2.next();
            V value = this.get(key);
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!keys2.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public abstract V getOrDefault(Object var1, V var2);

    @Override
    public abstract V putIfAbsent(K var1, V var2);

    public abstract boolean containsKeyIndex(int var1);

    public IndexableMap<K, V> asUnmodifiable() {
        return new IndexableMap<K, V>(){

            @Override
            public V putByIndex(int keyIndex, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V putByIndexIfAbsent(int keyIndex, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V getByIndex(int keyIndex) {
                return IndexableMap.this.getByIndex(keyIndex);
            }

            @Override
            public V getByIndexOrDefault(int keyIndex, V defaultValue) {
                return IndexableMap.this.getByIndexOrDefault(keyIndex, defaultValue);
            }

            @Override
            public V removeByIndex(int keyIndex) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int indexOfKey(K key) {
                return IndexableMap.this.indexOfKey(key);
            }

            @Override
            public K keyOfIndex(int keyIndex) {
                return IndexableMap.this.keyOfIndex(keyIndex);
            }

            @Override
            public int size() {
                return IndexableMap.this.size();
            }

            @Override
            public boolean containsKey(Object key) {
                return IndexableMap.this.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return IndexableMap.this.containsValue(value);
            }

            @Override
            public V get(Object key) {
                return IndexableMap.this.get(key);
            }

            @Override
            public V put(K key, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<K> keySet() {
                return IndexableMap.this.keySet();
            }

            @Override
            public V getOrDefault(Object key, V defaultValue) {
                return IndexableMap.this.getOrDefault(key, defaultValue);
            }

            @Override
            public V putIfAbsent(K key, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsKeyIndex(int keyIndex) {
                return IndexableMap.this.containsKeyIndex(keyIndex);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

