/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.indexable;

import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.utils.Assert;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

public abstract class IndexableSet<V>
extends AbstractSet<V> {
    private static final IndexableSet<?> EMPTY = new IndexableSet<Object>(){

        @Override
        public int indexOf(Object value) {
            return -1;
        }

        @Override
        public Object valueOf(int index) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public IndexableSet<Object> asUnmodifiable() {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public static <V> IndexableSet<V> EMPTY() {
        return EMPTY;
    }

    public abstract int indexOf(V var1);

    public abstract V valueOf(int var1);

    public final boolean addAll(V[] valuesToAdd) {
        if (valuesToAdd == null || valuesToAdd.length == 0) {
            return false;
        }
        boolean anyAdd = false;
        for (V value : valuesToAdd) {
            if (!this.add(value)) continue;
            anyAdd = true;
        }
        return anyAdd;
    }

    @Override
    public final Iterator<V> iterator() {
        return new Iterator<V>(){
            final int size;
            int i;
            {
                this.size = IndexableSet.this.size();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.size;
            }

            @Override
            public V next() {
                return IndexableSet.this.valueOf(this.i++);
            }
        };
    }

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public final boolean remove(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public IndexableSet<V> asUnmodifiable() {
        return new IndexableSet<V>(){

            @Override
            public int indexOf(V value) {
                return IndexableSet.this.indexOf(value);
            }

            @Override
            public V valueOf(int index) {
                return IndexableSet.this.valueOf(index);
            }

            @Override
            public boolean contains(Object o) {
                return IndexableSet.this.contains(o);
            }

            @Override
            public IndexableSet<V> asUnmodifiable() {
                return this;
            }

            @Override
            public int size() {
                return IndexableSet.this.size();
            }

            @Override
            public boolean add(V v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public final IntList findIndicesIn(IndexableSet<V> other) {
        Assert.that(other != null);
        if (other == this) {
            return null;
        }
        boolean equals = true;
        int[] indexes = new int[this.size()];
        int l = indexes.length;
        for (int i = 0; i < l; ++i) {
            indexes[i] = other.indexOf(this.valueOf(i));
            if (i == indexes[i]) continue;
            equals = false;
        }
        if (equals && indexes.length == other.size()) {
            return null;
        }
        return new IntList(indexes).asUnmodifiable();
    }

    public final <T> Iterable<T> apply(final Function<V, T> applier) {
        return () -> new Iterator<T>(){
            final int size;
            int i;
            {
                this.size = IndexableSet.this.size();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.size;
            }

            @Override
            public T next() {
                return applier.apply(IndexableSet.this.valueOf(this.i++));
            }
        };
    }

    public final boolean hasOverlaps(Set<V> elements) {
        if (elements == null || this.size() == 0 || elements.size() == 0) {
            return false;
        }
        for (V e : elements) {
            if (!this.contains(e)) continue;
            return true;
        }
        return false;
    }
}

