/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.indexable;

import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import gnu.trove.map.hash.TObjectIntHashMap;

public class LinkedSet<V>
extends IndexableSet<V> {
    final List<V> values;
    final TObjectIntHashMap<V> indexes;

    public LinkedSet() {
        this(4);
    }

    public LinkedSet(int initialCapacity) {
        this.values = new List(initialCapacity);
        this.indexes = new TObjectIntHashMap(initialCapacity, 0.5f, -1);
    }

    public LinkedSet(V[] values2) {
        this(values2.length);
        for (V value : values2) {
            this.add(value);
        }
    }

    public LinkedSet(Iterable<V> values2) {
        this(4);
        for (V value : values2) {
            this.add(value);
        }
    }

    @Override
    public int indexOf(Object value) {
        return this.indexes.get(value);
    }

    @Override
    public V valueOf(int index) {
        return this.values.get(index);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexes.containsKey(o);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean add(V value) {
        if (this.indexes.containsKey(value)) {
            return false;
        }
        int index = this.values.size();
        this.indexes.put(value, index);
        this.values.add(value);
        return true;
    }

    @Override
    public void clear() {
        this.indexes.clear();
        this.values.clear();
    }
}

