/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.indexable;

import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class NamedSet<V>
extends IndexableSet<V> {
    final List<NamedSetItem<V>> values;
    final TObjectIntHashMap<Object> indexes;

    public NamedSet() {
        this(4);
    }

    public NamedSet(int initialCapacity) {
        this.values = new List(initialCapacity);
        this.indexes = new TObjectIntHashMap(initialCapacity, 0.5f, -1);
    }

    @Override
    public int indexOf(V value) {
        return this.indexes.get(value);
    }

    @Override
    public V valueOf(int index) {
        return this.values.get((int)index).main;
    }

    @Override
    public int indexOf(String alias) {
        return this.indexes.get(alias);
    }

    public V valueOf(String alias) {
        int index = this.indexOf(alias);
        if (index == -1) {
            return null;
        }
        return this.values.get((int)index).main;
    }

    public V valueOf(V object) {
        int index = this.indexOf(object);
        if (index == -1) {
            return null;
        }
        return this.values.get((int)index).main;
    }

    public Set<String> aliasesOf(int index) {
        return this.values.get(index);
    }

    public Set<String> aliasesOf(String value) {
        int index = this.indexOf(value);
        if (index != -1) {
            return this.values.get(index);
        }
        return null;
    }

    public Set<String> aliasesOf(V value) {
        int index = this.indexOf(value);
        if (index != -1) {
            return this.values.get(index);
        }
        return null;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean contains(Object o) {
        if (this.indexes.containsKey(o)) {
            return true;
        }
        return this.indexes.containsKey(o);
    }

    @Override
    public boolean add(V value) {
        if (this.indexes.containsKey(value)) {
            return false;
        }
        int index = this.values.size();
        this.indexes.put(value, index);
        this.values.add(new NamedSetItem(value));
        return true;
    }

    @Override
    public void clear() {
        this.indexes.clear();
        this.values.clear();
    }

    public NamedSet<V> add(V value, String alias) {
        int index1 = this.indexes.get(value);
        int index2 = this.indexes.get(alias);
        if (index2 == -1) {
            if (index1 == -1) {
                int index = this.values.size();
                this.indexes.put(value, index);
                this.indexes.put(alias, index);
                this.values.add(new NamedSetItem(value).addKey(alias));
            } else {
                this.indexes.put(alias, index1);
                ((NamedSetItem)this.values.get(index1)).addKey(alias);
            }
        } else if (index1 != index2) {
            throw new UnsupportedOperationException("Duplicated alias key: " + alias);
        }
        return this;
    }

    public NamedSet<V> adds(V value, Iterable<String> aliases) {
        if (aliases == null) {
            this.add(value);
            return this;
        }
        int index1 = this.indexes.get(value);
        if (index1 == -1) {
            for (String string : aliases) {
                if (!this.indexes.contains(string)) continue;
                throw new UnsupportedOperationException("Duplicated alias key: " + string);
            }
            NamedSetItem elements = new NamedSetItem(value);
            index1 = this.values.size();
            this.indexes.put(value, index1);
            for (String alias : aliases) {
                elements.addKey(alias);
                this.indexes.put(alias, index1);
            }
            this.values.add(elements);
        } else {
            for (String string : aliases) {
                int index2 = this.indexes.get(string);
                if (index2 == -1 || index2 == index1) continue;
                throw new UnsupportedOperationException("Duplicated alias key: " + string);
            }
            NamedSetItem<V> elements = this.values.get(index1);
            this.indexes.put(value, index1);
            for (String alias : aliases) {
                ((NamedSetItem)elements).addKey(alias);
                this.indexes.put(alias, index1);
            }
        }
        return this;
    }

    public NamedSet<V> adds(V value, String ... aliases) {
        if (aliases.length == 0) {
            this.add(value);
            return this;
        }
        int index1 = this.indexes.get(value);
        if (index1 == -1) {
            for (String alias : aliases) {
                if (!this.indexes.contains(alias)) continue;
                throw new UnsupportedOperationException("Duplicated alias key: " + alias);
            }
            NamedSetItem namedSetItem = new NamedSetItem(value);
            index1 = this.values.size();
            this.indexes.put(value, index1);
            for (String alias : aliases) {
                namedSetItem.addKey(alias);
                this.indexes.put(alias, index1);
            }
            this.values.add(namedSetItem);
        } else {
            for (String alias : aliases) {
                int index2 = this.indexes.get(alias);
                if (index2 == -1 || index2 == index1) continue;
                throw new UnsupportedOperationException("Duplicated alias key: " + alias);
            }
            NamedSetItem<V> namedSetItem = this.values.get(index1);
            this.indexes.put(value, index1);
            for (String alias : aliases) {
                ((NamedSetItem)namedSetItem).addKey(alias);
                this.indexes.put(alias, index1);
            }
        }
        return this;
    }

    private static class NamedSetItem<V>
    extends AbstractSet<String> {
        final V main;
        final THashSet<String> aliases = new TLinkedHashSet<String>(2);

        private NamedSetItem(V main) {
            this.main = main;
        }

        private NamedSetItem<V> addKey(String key) {
            this.aliases.add(key);
            return this;
        }

        public boolean contains(String alias) {
            return this.aliases.contains(alias);
        }

        @Override
        public Iterator<String> iterator() {
            return this.aliases.iterator();
        }

        @Override
        public int size() {
            return this.aliases.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.aliases.contains(o);
        }
    }
}

