/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.interval;

import java.util.Objects;

public final class DoubleInterval
implements Comparable<DoubleInterval> {
    private final double start;
    private final double end;

    public DoubleInterval(double start, double end) {
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        if (Double.isNaN(start) || Double.isNaN(end)) {
            throw new IllegalArgumentException("NaN endpoints");
        }
        this.start = start;
        this.end = end;
    }

    public double start() {
        return this.start;
    }

    public double end() {
        return this.end;
    }

    public boolean contains(double value) {
        if (Double.isNaN(value)) {
            return false;
        }
        if (this.start > value) {
            return false;
        }
        return this.end >= value;
    }

    public boolean contains(double value, boolean containsEnd) {
        if (Double.isNaN(value)) {
            return false;
        }
        if (this.start > value) {
            return false;
        }
        return containsEnd && this.end >= value || this.end > value;
    }

    public boolean contains(double start, double end) {
        if (Double.isNaN(start) || Double.isNaN(end)) {
            return false;
        }
        return this.start <= start && start <= end && this.end >= end;
    }

    public boolean overlaps(DoubleInterval otherInterval) {
        return this.overlaps(otherInterval, true);
    }

    public boolean overlaps(DoubleInterval otherInterval, boolean containsEnd) {
        if (otherInterval == this) {
            return true;
        }
        if (otherInterval == null) {
            throw new IllegalArgumentException("null interval");
        }
        double start = Math.max(this.start, otherInterval.start());
        double end = Math.min(this.end, otherInterval.end());
        if (containsEnd) {
            return start <= end;
        }
        return start < end;
    }

    public boolean overlaps(double start, double end) {
        return this.overlaps(start, end, true);
    }

    public boolean overlaps(double start, double end, boolean containsEnd) {
        if (Double.isNaN(start) || Double.isNaN(end)) {
            throw new IllegalArgumentException("NaN endpoints");
        }
        start = Math.max(this.start, start);
        end = Math.min(this.end, end);
        if (containsEnd) {
            return start <= end;
        }
        return start < end;
    }

    public DoubleInterval getOverlaps(DoubleInterval otherInterval) {
        if (otherInterval == this) {
            return this;
        }
        if (otherInterval == null) {
            throw new IllegalArgumentException("null interval");
        }
        double start = Math.max(this.start, otherInterval.start());
        double end = Math.min(this.end, otherInterval.end());
        if (start == this.start && end == this.end) {
            return this;
        }
        if (start == otherInterval.start() && end == otherInterval.end()) {
            return otherInterval;
        }
        if (start > end) {
            return null;
        }
        return new DoubleInterval(start, end);
    }

    public DoubleInterval getOverlaps(double start, double end) {
        if (Double.isNaN(start) || Double.isNaN(end)) {
            throw new IllegalArgumentException("NaN endpoints");
        }
        start = Math.max(this.start, start);
        end = Math.min(this.end, end);
        if (start == this.start && end == this.end) {
            return this;
        }
        if (start > end) {
            return null;
        }
        return new DoubleInterval(start, end);
    }

    public int hashCode() {
        return Objects.hash(this.start(), this.end());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleInterval range = (DoubleInterval)o;
        return this.start() == range.start() && this.end() == range.end();
    }

    public String toString() {
        return this.start + "~" + this.end;
    }

    @Override
    public int compareTo(DoubleInterval o) {
        int status = Double.compare(this.start, o.start);
        if (status == 0) {
            status = Double.compare(this.end, o.end);
        }
        return status;
    }
}

