/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.interval;

import java.util.Objects;

public final class FloatInterval
implements Comparable<FloatInterval> {
    private final float start;
    private final float end;

    public FloatInterval(float start, float end) {
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        if (Float.isNaN(start) || Float.isNaN(end)) {
            throw new IllegalArgumentException("NaN endpoints");
        }
        this.start = start;
        this.end = end;
    }

    public float start() {
        return this.start;
    }

    public float end() {
        return this.end;
    }

    public boolean contains(float value) {
        if (Float.isNaN(value)) {
            return false;
        }
        if (this.start > value) {
            return false;
        }
        return this.end >= value;
    }

    public boolean contains(float value, boolean containsEnd) {
        if (Float.isNaN(value)) {
            return false;
        }
        if (this.start > value) {
            return false;
        }
        return containsEnd && this.end >= value || this.end > value;
    }

    public boolean contains(float start, float end) {
        if (Float.isNaN(start) || Float.isNaN(end)) {
            return false;
        }
        return this.start <= start && start <= end && this.end >= end;
    }

    public boolean overlaps(FloatInterval otherInterval) {
        return this.overlaps(otherInterval, true);
    }

    public boolean overlaps(FloatInterval otherInterval, boolean containsEnd) {
        if (otherInterval == this) {
            return true;
        }
        if (otherInterval == null) {
            throw new IllegalArgumentException("null interval");
        }
        float start = Math.max(this.start, otherInterval.start());
        float end = Math.min(this.end, otherInterval.end());
        if (containsEnd) {
            return start <= end;
        }
        return start < end;
    }

    public boolean overlaps(float start, float end) {
        return this.overlaps(start, end, true);
    }

    public boolean overlaps(float start, float end, boolean containsEnd) {
        if (Float.isNaN(start) || Float.isNaN(end)) {
            throw new IllegalArgumentException("NaN endpoints");
        }
        start = Math.max(this.start, start);
        end = Math.min(this.end, end);
        if (containsEnd) {
            return start <= end;
        }
        return start < end;
    }

    public FloatInterval getOverlaps(FloatInterval otherInterval) {
        if (otherInterval == this) {
            return this;
        }
        if (otherInterval == null) {
            throw new IllegalArgumentException("null interval");
        }
        float start = Math.max(this.start, otherInterval.start());
        float end = Math.min(this.end, otherInterval.end());
        if (start == this.start && end == this.end) {
            return this;
        }
        if (start == otherInterval.start() && end == otherInterval.end()) {
            return otherInterval;
        }
        if (start > end) {
            return null;
        }
        return new FloatInterval(start, end);
    }

    public FloatInterval getOverlaps(float start, float end) {
        if (Float.isNaN(start) || Float.isNaN(end)) {
            throw new IllegalArgumentException("NaN endpoints");
        }
        start = Math.max(this.start, start);
        end = Math.min(this.end, end);
        if (start == this.start && end == this.end) {
            return this;
        }
        if (start > end) {
            return null;
        }
        return new FloatInterval(start, end);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.start()), Float.valueOf(this.end()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatInterval range = (FloatInterval)o;
        return this.start() == range.start() && this.end() == range.end();
    }

    public String toString() {
        return this.start + "~" + this.end;
    }

    @Override
    public int compareTo(FloatInterval o) {
        int status = Float.compare(this.start, o.start);
        if (status == 0) {
            status = Float.compare(this.end, o.end);
        }
        return status;
    }
}

