/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.interval;

import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import java.util.Objects;

public final class IntInterval
implements Comparable<IntInterval> {
    private final int start;
    private final int end;

    public IntInterval(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        this.start = start;
        this.end = end;
    }

    public static List<IntInterval> merge(List<IntInterval> intervals) {
        int i;
        Assert.that(intervals != null);
        if (intervals.size() == 0) {
            return new List<IntInterval>(0);
        }
        if (intervals.size() == 1) {
            return List.singleton(intervals.fastGet(0));
        }
        List<IntInterval> output = new List<IntInterval>();
        int offset = -1;
        for (i = 0; i < intervals.size(); ++i) {
            if (intervals.fastGet(i) == null) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            return new List<IntInterval>(0);
        }
        output.add(intervals.fastGet(offset));
        for (i = offset + 1; i < intervals.size(); ++i) {
            IntInterval last = output.lastGet(0);
            IntInterval curr = intervals.fastGet(i);
            if (curr == null) continue;
            if (curr.start() < last.start()) {
                throw new IllegalArgumentException("Ordered intervals are required here");
            }
            if (last.start() == curr.start()) {
                if (last.end() >= curr.end()) continue;
                output.fastSet(output.size() - 1, curr);
                continue;
            }
            if (last.end() + 1 >= curr.start()) {
                int start = last.start();
                int end = Math.max(curr.end(), last.end());
                if (end == last.end()) continue;
                output.fastSet(output.size() - 1, new IntInterval(start, end));
                continue;
            }
            output.add(curr);
        }
        return output;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public boolean contains(int value) {
        if (this.start > value) {
            return false;
        }
        return this.end >= value;
    }

    public boolean contains(int value, boolean containsEnd) {
        if (this.start > value) {
            return false;
        }
        return containsEnd && this.end >= value || this.end > value;
    }

    public boolean contains(int start, int end) {
        return this.start <= start && start <= end && this.end >= end;
    }

    public boolean overlaps(IntInterval otherInterval) {
        return this.overlaps(otherInterval, true);
    }

    public boolean overlaps(IntInterval otherInterval, boolean containsEnd) {
        if (otherInterval == this) {
            return true;
        }
        if (otherInterval == null) {
            throw new IllegalArgumentException("null interval");
        }
        int start = Math.max(this.start, otherInterval.start());
        int end = Math.min(this.end, otherInterval.end());
        if (containsEnd) {
            return start <= end;
        }
        return start < end;
    }

    public boolean overlaps(int start, int end) {
        return this.overlaps(start, end, true);
    }

    public boolean overlaps(int start, int end, boolean containsEnd) {
        start = Math.max(this.start, start);
        end = Math.min(this.end, end);
        if (containsEnd) {
            return start <= end;
        }
        return start < end;
    }

    public IntInterval getOverlaps(IntInterval otherInterval) {
        if (otherInterval == this) {
            return this;
        }
        if (otherInterval == null) {
            throw new IllegalArgumentException("null interval");
        }
        int start = Math.max(this.start, otherInterval.start());
        int end = Math.min(this.end, otherInterval.end());
        if (start == this.start && end == this.end) {
            return this;
        }
        if (start == otherInterval.start() && end == otherInterval.end()) {
            return otherInterval;
        }
        if (start > end) {
            return null;
        }
        return new IntInterval(start, end);
    }

    public IntInterval getOverlaps(int start, int end) {
        start = Math.max(this.start, start);
        end = Math.min(this.end, end);
        if (start == this.start && end == this.end) {
            return this;
        }
        if (start > end) {
            return null;
        }
        return new IntInterval(start, end);
    }

    public int hashCode() {
        return Objects.hash(this.start(), this.end());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntInterval range = (IntInterval)o;
        return this.start() == range.start() && this.end() == range.end();
    }

    public String toString() {
        return this.start + "~" + this.end;
    }

    public List<IntInterval> divide(int expectSize, boolean containsEnd) {
        if (expectSize <= 0) {
            throw new IllegalArgumentException();
        }
        List<IntInterval> intervals = new List<IntInterval>(expectSize);
        int length = this.end - this.start + (containsEnd ? 1 : 0);
        if (expectSize >= length) {
            if (containsEnd) {
                for (int i = 0; i < length; ++i) {
                    intervals.add(new IntInterval(this.start + i, this.start + i));
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    intervals.add(new IntInterval(this.start + i, this.start + i + 1));
                }
            }
            return intervals;
        }
        int eachIntervalLength = length / expectSize;
        int addOnes = length % expectSize;
        int[] pointer = new int[expectSize + 1];
        pointer[expectSize] = this.end;
        if (containsEnd) {
            int i;
            pointer[0] = this.start - 1;
            for (i = 1; i < expectSize; ++i) {
                pointer[i] = i <= addOnes ? pointer[i - 1] + eachIntervalLength + 1 : pointer[i - 1] + eachIntervalLength;
            }
            for (i = 0; i < expectSize; ++i) {
                intervals.add(new IntInterval(pointer[i] + 1, pointer[i + 1]));
            }
        } else {
            int i;
            pointer[0] = this.start;
            for (i = 1; i < expectSize; ++i) {
                pointer[i] = i <= addOnes ? pointer[i - 1] + eachIntervalLength + 1 : pointer[i - 1] + eachIntervalLength;
            }
            for (i = 0; i < expectSize; ++i) {
                intervals.add(new IntInterval(pointer[i], pointer[i + 1]));
            }
        }
        return intervals;
    }

    @Override
    public int compareTo(IntInterval o) {
        int status = Long.compare(this.start, o.start);
        if (status == 0) {
            status = Long.compare(this.end, o.end);
        }
        return status;
    }
}

