/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.interval;

import edu.sysu.pmglab.utils.ValueUtils;
import java.util.Objects;

public final class Interval<V extends Comparable<V>>
implements Comparable<Interval<V>> {
    private final V start;
    private final V end;

    public Interval(V start, V end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("null endpoint");
        }
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("start > end");
        }
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return this.start + "~" + this.end;
    }

    public V start() {
        return this.start;
    }

    public V end() {
        return this.end;
    }

    public boolean contains(V value) {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (this.start.compareTo(value) > 0) {
            return false;
        }
        return this.end.compareTo(value) >= 0;
    }

    public boolean contains(V value, boolean containsEnd) {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (this.start.compareTo(value) > 0) {
            return false;
        }
        return containsEnd && this.end.compareTo(value) >= 0 || this.end.compareTo(value) > 0;
    }

    public boolean contains(V start, V end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("null endpoints");
        }
        return this.start.compareTo(start) <= 0 && start.compareTo(end) <= 0 && this.end.compareTo(end) >= 0;
    }

    public boolean overlaps(Interval<V> otherInterval) {
        return this.overlaps((V)otherInterval, (V)true);
    }

    public boolean overlaps(Interval<V> otherInterval, boolean containsEnd) {
        if (otherInterval == this) {
            throw new IllegalArgumentException("null interval");
        }
        V start = ValueUtils.max(this.start, otherInterval.start());
        V end = ValueUtils.min(this.end, otherInterval.end());
        if (containsEnd) {
            return start.compareTo(end) <= 0;
        }
        return start.compareTo(end) < 0;
    }

    public boolean overlaps(V start, V end) {
        return this.overlaps(start, end, true);
    }

    public boolean overlaps(V start, V end, boolean containsEnd) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("null endpoints");
        }
        start = ValueUtils.max(this.start, start);
        end = ValueUtils.min(this.end, end);
        if (containsEnd) {
            return start.compareTo(end) <= 0;
        }
        return start.compareTo(end) < 0;
    }

    public Interval<V> getOverlaps(Interval<V> otherInterval) {
        if (otherInterval == this) {
            throw new IllegalArgumentException("null interval");
        }
        V start = ValueUtils.max(this.start, otherInterval.start());
        V end = ValueUtils.min(this.end, otherInterval.end());
        if (start.compareTo(this.start) == 0 && end.compareTo(this.end) == 0) {
            return this;
        }
        if (start.compareTo(otherInterval.start()) == 0 && end.compareTo(otherInterval.end()) == 0) {
            return otherInterval;
        }
        if (start.compareTo(end) > 0) {
            return null;
        }
        return new Interval<V>(start, end);
    }

    public Interval<V> getOverlaps(V start, V end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("null endpoints");
        }
        start = ValueUtils.max(this.start, start);
        end = ValueUtils.min(this.end, end);
        if (start.compareTo(this.start) == 0 && end.compareTo(this.end) == 0) {
            return this;
        }
        if (start.compareTo(end) > 0) {
            return null;
        }
        return new Interval<V>(start, end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        return Objects.equals(this.start, interval.start) && Objects.equals(this.end, interval.end);
    }

    public int hashCode() {
        return Objects.hash(this.start(), this.end());
    }

    @Override
    public int compareTo(Interval<V> o) {
        int status = this.start.compareTo(o.start);
        if (status == 0) {
            status = this.end.compareTo(o.end);
        }
        return status;
    }
}

