/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.interval;

import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import java.util.Objects;

public final class LongInterval
implements Comparable<LongInterval> {
    private final long start;
    private final long end;

    public LongInterval(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        this.start = start;
        this.end = end;
    }

    public static List<LongInterval> merge(List<LongInterval> intervals) {
        int i;
        Assert.that(intervals != null);
        if (intervals.size() == 0) {
            return new List<LongInterval>(0);
        }
        if (intervals.size() == 1) {
            return List.singleton(intervals.fastGet(0));
        }
        List<LongInterval> output = new List<LongInterval>();
        int offset = -1;
        for (i = 0; i < intervals.size(); ++i) {
            if (intervals.fastGet(i) == null) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            return new List<LongInterval>(0);
        }
        output.add(intervals.fastGet(offset));
        for (i = offset + 1; i < intervals.size(); ++i) {
            LongInterval last = output.lastGet(0);
            LongInterval curr = intervals.fastGet(i);
            if (curr == null) continue;
            if (curr.start() < last.start()) {
                throw new IllegalArgumentException("Ordered intervals are required here");
            }
            if (last.start() == curr.start()) {
                if (last.end() >= curr.end()) continue;
                output.fastSet(output.size() - 1, curr);
                continue;
            }
            if (last.end() + 1L >= curr.start()) {
                long start = last.start();
                long end = Math.max(curr.end(), last.end());
                if (end == last.end()) continue;
                output.fastSet(output.size() - 1, new LongInterval(start, end));
                continue;
            }
            output.add(curr);
        }
        return output;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public boolean contains(long value) {
        if (this.start > value) {
            return false;
        }
        return this.end >= value;
    }

    public boolean contains(long value, boolean containsEnd) {
        if (this.start > value) {
            return false;
        }
        return containsEnd && this.end >= value || this.end > value;
    }

    public boolean contains(long start, long end) {
        return this.start <= start && start <= end && this.end >= end;
    }

    public boolean overlaps(LongInterval otherInterval) {
        return this.overlaps(otherInterval, true);
    }

    public boolean overlaps(LongInterval otherInterval, boolean containsEnd) {
        if (otherInterval == this) {
            return true;
        }
        if (otherInterval == null) {
            throw new IllegalArgumentException("null interval");
        }
        long start = Math.max(this.start, otherInterval.start());
        long end = Math.min(this.end, otherInterval.end());
        if (containsEnd) {
            return start <= end;
        }
        return start < end;
    }

    public boolean overlaps(long start, long end) {
        return this.overlaps(start, end, true);
    }

    public boolean overlaps(long start, long end, boolean containsEnd) {
        start = Math.max(this.start, start);
        end = Math.min(this.end, end);
        if (containsEnd) {
            return start <= end;
        }
        return start < end;
    }

    public LongInterval getOverlaps(LongInterval otherInterval) {
        if (otherInterval == this) {
            return this;
        }
        if (otherInterval == null) {
            throw new IllegalArgumentException("null interval");
        }
        long start = Math.max(this.start, otherInterval.start());
        long end = Math.min(this.end, otherInterval.end());
        if (start == this.start && end == this.end) {
            return this;
        }
        if (start == otherInterval.start() && end == otherInterval.end()) {
            return otherInterval;
        }
        if (start > end) {
            return null;
        }
        return new LongInterval(start, end);
    }

    public LongInterval getOverlaps(long start, long end) {
        start = Math.max(this.start, start);
        end = Math.min(this.end, end);
        if (start == this.start && end == this.end) {
            return this;
        }
        if (start > end) {
            return null;
        }
        return new LongInterval(start, end);
    }

    public int hashCode() {
        return Objects.hash(this.start(), this.end());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongInterval range = (LongInterval)o;
        return this.start() == range.start() && this.end() == range.end();
    }

    public String toString() {
        return this.start + "~" + this.end;
    }

    public List<LongInterval> divide(int expectSize, boolean containsEnd) {
        if (expectSize <= 0) {
            throw new IllegalArgumentException();
        }
        List<LongInterval> intervals = new List<LongInterval>(expectSize);
        long length = this.end - this.start + (long)(containsEnd ? 1 : 0);
        if ((long)expectSize >= length) {
            if (containsEnd) {
                int i = 0;
                while ((long)i < length) {
                    intervals.add(new LongInterval(this.start + (long)i, this.start + (long)i));
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < length) {
                    intervals.add(new LongInterval(this.start + (long)i, this.start + (long)i + 1L));
                    ++i;
                }
            }
            return intervals;
        }
        long eachIntervalLength = length / (long)expectSize;
        long addOnes = length % (long)expectSize;
        long[] pointer = new long[expectSize + 1];
        pointer[expectSize] = this.end;
        if (containsEnd) {
            int i;
            pointer[0] = this.start - 1L;
            for (i = 1; i < expectSize; ++i) {
                pointer[i] = (long)i <= addOnes ? pointer[i - 1] + eachIntervalLength + 1L : pointer[i - 1] + eachIntervalLength;
            }
            for (i = 0; i < expectSize; ++i) {
                intervals.add(new LongInterval(pointer[i] + 1L, pointer[i + 1]));
            }
        } else {
            int i;
            pointer[0] = this.start;
            for (i = 1; i < expectSize; ++i) {
                pointer[i] = (long)i <= addOnes ? pointer[i - 1] + eachIntervalLength + 1L : pointer[i - 1] + eachIntervalLength;
            }
            for (i = 0; i < expectSize; ++i) {
                intervals.add(new LongInterval(pointer[i], pointer[i + 1]));
            }
        }
        return intervals;
    }

    @Override
    public int compareTo(LongInterval o) {
        int status = Long.compare(this.start, o.start);
        if (status == 0) {
            status = Long.compare(this.end, o.end);
        }
        return status;
    }
}

