/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.generics;

import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.container.intervaltree.generics.IntervalNode;
import edu.sysu.pmglab.container.intervaltree.generics.IntervalObject;
import edu.sysu.pmglab.container.intervaltree.generics.IntervalTree;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;

class ImplIntervalTree<T extends Comparable<T>, V>
implements IntervalTree<T, V> {
    final IntervalNode<T, V> root;
    final List<IntervalObject<T, V>> objects = new List();

    public ImplIntervalTree(List<IntervalObject<T, V>> objects) {
        for (IntervalObject<T, V> object : objects) {
            this.objects.add(object);
        }
        this.root = new IntervalNode<T, V>(this.objects);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.root.print(builder, "", "");
        return builder.toString();
    }

    @Override
    public Iterator<IntervalObject<T, V>> iterator() {
        return this.objects.iterator();
    }

    @Override
    public boolean contains(T pos) {
        return this.root.contains(pos);
    }

    @Override
    public boolean contains(T start, T end) {
        if (start.compareTo(end) == 0) {
            return this.contains(start);
        }
        if (start.compareTo(end) > 0) {
            return false;
        }
        return this.root.contains(start, end);
    }

    @Override
    public boolean overlaps(T start, T end) {
        if (start.compareTo(end) == 0) {
            return this.contains(start);
        }
        if (start.compareTo(end) > 0) {
            return false;
        }
        return this.root.overlaps(start, end);
    }

    @Override
    public List<V> getContains(T pos) {
        if (this.contains(pos)) {
            List container = new List();
            this.root.collectObjectContains(pos, container);
            if (container.size() > 0) {
                container.sort();
                return container.apply(IntervalObject::data);
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<V> getContains(T start, T end) {
        if (this.contains(start, end)) {
            List container = new List();
            this.root.collectObjectContains(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container.apply(IntervalObject::data);
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<V> getOverlaps(T start, T end) {
        if (this.overlaps(start, end)) {
            List container = new List();
            this.root.collectObjectOverlaps(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container.apply(IntervalObject::data);
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<IntervalObject<T, V>> getIntervalContains(T pos) {
        if (this.contains(pos)) {
            List container = new List();
            this.root.collectObjectContains(pos, container);
            if (container.size() > 0) {
                container.sort();
                return container;
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<IntervalObject<T, V>> getIntervalContains(T start, T end) {
        if (this.contains(start, end)) {
            List container = new List();
            this.root.collectObjectContains(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container;
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<IntervalObject<T, V>> getIntervalOverlaps(T start, T end) {
        if (this.overlaps(start, end)) {
            List container = new List();
            this.root.collectObjectOverlaps(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container;
            }
        }
        return List.EMPTY();
    }

    @Override
    public Interval<T> getEndpoint() {
        return this.root.getRange();
    }

    @Override
    public int size() {
        return this.objects.size();
    }
}

