/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.generics;

import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.container.intervaltree.generics.IntervalObject;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.ValueUtils;

class IntervalNode<T extends Comparable<T>, V> {
    final T center;
    final Interval<T> range;
    final Interval<T> globalRange;
    final IntervalNode<T, V> left;
    final IntervalNode<T, V> right;
    final List<IntervalObject<T, V>> objects;

    public IntervalNode(List<IntervalObject<T, V>> objects) {
        if (objects.size() == 0) {
            throw new IllegalArgumentException();
        }
        List<T> endpoints = new List<T>(objects.size() << 1);
        for (IntervalObject<T, V> intervalObject : objects) {
            endpoints.add(intervalObject.start());
            endpoints.add(intervalObject.end());
        }
        endpoints.sort();
        this.center = (Comparable)endpoints.get(endpoints.size() / 2);
        List<IntervalObject<IntervalObject<T, V>, V>> left = new List<IntervalObject<IntervalObject<T, V>, V>>(Math.min(objects.size(), 2));
        List<IntervalObject<IntervalObject<T, V>, V>> right = new List<IntervalObject<IntervalObject<T, V>, V>>(Math.min(objects.size(), 2));
        this.objects = new List(Math.min(objects.size(), 2));
        Object minPos = null;
        Object maxPos = null;
        Object globalMinPos = null;
        Object globalMaxPos = null;
        for (IntervalObject<T, V> object : objects) {
            globalMinPos = globalMinPos == null ? (Object)object.start() : ValueUtils.min(object.start(), globalMinPos);
            globalMaxPos = globalMaxPos == null ? object.end() : ValueUtils.max(object.end(), globalMaxPos);
            if (object.end().compareTo(this.center) < 0) {
                left.add(object);
                continue;
            }
            if (object.start().compareTo(this.center) > 0) {
                right.add(object);
                continue;
            }
            this.objects.add(object);
            minPos = minPos == null ? object.start() : ValueUtils.min(object.start(), minPos);
            if (maxPos == null) {
                maxPos = object.end();
                continue;
            }
            maxPos = ValueUtils.max(object.end(), maxPos);
        }
        this.range = new Interval<Object>(minPos, maxPos);
        this.globalRange = new Interval<Object>(globalMinPos, globalMaxPos);
        this.objects.sort(IntervalObject::compareTo);
        this.left = left.size() > 0 ? new IntervalNode<T, V>(left) : null;
        this.right = right.size() > 0 ? new IntervalNode<T, V>(right) : null;
    }

    public boolean contains(T pos) {
        if (this.globalRange.contains(pos)) {
            if (this.range.contains(pos)) {
                return true;
            }
            if (pos.compareTo(this.center) < 0 && this.left != null) {
                return this.left.contains(pos);
            }
            if (pos.compareTo(this.center) > 0 && this.right != null) {
                return this.right.contains(pos);
            }
        }
        return false;
    }

    public boolean contains(T start, T end) {
        if (this.globalRange.contains(start, end)) {
            if (this.range.contains(start, end)) {
                if (end.compareTo(this.center) <= 0 || start.compareTo(this.center) >= 0) {
                    return true;
                }
                for (IntervalObject<T, V> object : this.objects) {
                    if (object.contains(start, end)) {
                        return true;
                    }
                    if (object.start().compareTo(end) <= 0) continue;
                    break;
                }
            }
            if (end.compareTo(this.center) < 0 && this.left != null) {
                return this.left.contains(start, end);
            }
            if (start.compareTo(this.center) > 0 && this.right != null) {
                return this.right.contains(start, end);
            }
        }
        return false;
    }

    public boolean overlaps(T start, T end) {
        if (this.globalRange.overlaps(start, end)) {
            boolean overlaps;
            if (this.range.overlaps(start, end)) {
                return true;
            }
            if (start.compareTo(this.center) < 0 && this.left != null && (overlaps = this.left.overlaps(start, end))) {
                return true;
            }
            if (end.compareTo(this.center) > 0 && this.right != null && (overlaps = this.right.overlaps(start, end))) {
                return true;
            }
        }
        return false;
    }

    public void collectObjectContains(T pos, List<IntervalObject<T, V>> returns) {
        if (this.globalRange.contains(pos)) {
            if (this.range.contains(pos)) {
                for (IntervalObject<T, V> object : this.objects) {
                    if (object.contains(pos)) {
                        returns.add(object);
                        continue;
                    }
                    if (object.start().compareTo(pos) <= 0) continue;
                    break;
                }
            }
            if (this.globalRange.contains(pos)) {
                if (pos.compareTo(this.center) < 0 && this.left != null) {
                    this.left.collectObjectContains((IntervalObject<T, V>)pos, returns);
                } else if (pos.compareTo(this.center) > 0 && this.right != null) {
                    this.right.collectObjectContains((IntervalObject<T, V>)pos, returns);
                }
            }
        }
    }

    public void collectObjectContains(T start, T end, List<IntervalObject<T, V>> returns) {
        if (this.globalRange.contains(start, end)) {
            if (this.range.contains(start, end)) {
                for (IntervalObject<T, V> object : this.objects) {
                    if (object.contains(start, end)) {
                        returns.add(object);
                        continue;
                    }
                    if (object.start().compareTo(end) <= 0) continue;
                    break;
                }
            }
            if (end.compareTo(this.center) < 0 && this.left != null) {
                this.left.collectObjectContains((IntervalObject<T, V>)start, (IntervalObject<T, V>)end, returns);
            } else if (start.compareTo(this.center) > 0 && this.right != null) {
                this.right.collectObjectContains((IntervalObject<T, V>)start, (IntervalObject<T, V>)end, returns);
            }
        }
    }

    public void collectObjectOverlaps(T start, T end, List<IntervalObject<T, V>> returns) {
        if (this.globalRange.overlaps(start, end)) {
            if (this.range.overlaps(start, end)) {
                for (IntervalObject<T, V> object : this.objects) {
                    if (object.overlaps(start, end)) {
                        returns.add(object);
                        continue;
                    }
                    if (object.start().compareTo(end) <= 0) continue;
                    break;
                }
            }
            if (start.compareTo(this.center) < 0 && this.left != null) {
                this.left.collectObjectOverlaps((IntervalObject<T, V>)start, (IntervalObject<T, V>)end, returns);
            }
            if (end.compareTo(this.center) > 0 && this.right != null) {
                this.right.collectObjectOverlaps((IntervalObject<T, V>)start, (IntervalObject<T, V>)end, returns);
            }
        }
    }

    public Interval<T> getRange() {
        return this.globalRange;
    }

    public void print(StringBuilder buffer, String prefix, String childrenPrefix) {
        buffer.append(prefix);
        buffer.append("Node: " + this.center + " " + this.objects);
        buffer.append("\n");
        if (this.left != null) {
            this.left.print(buffer, childrenPrefix + "\u251c\u2500\u2500 ", childrenPrefix + "\u2502   ");
        }
        if (this.right != null) {
            this.right.print(buffer, childrenPrefix + "\u251c\u2500\u2500 ", childrenPrefix + "\u2502   ");
        }
    }
}

