/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.generics;

import edu.sysu.pmglab.container.interval.Interval;

public class IntervalObject<T extends Comparable<T>, V>
implements Comparable<IntervalObject<T, V>> {
    final V data;
    final Interval<T> interval;

    public IntervalObject(Interval<T> interval, V data) {
        if (interval == null) {
            throw new NullPointerException("null interval");
        }
        this.interval = interval;
        this.data = data;
    }

    public IntervalObject(T start, T end, V data) {
        this.interval = new Interval<T>(start, end);
        this.data = data;
    }

    public V data() {
        return this.data;
    }

    public T start() {
        return this.interval.start();
    }

    public T end() {
        return this.interval.end();
    }

    public boolean contains(T pos) {
        return this.interval.contains(pos, (T)true);
    }

    public boolean contains(T start, T end) {
        return this.interval.contains(start, end);
    }

    public boolean overlaps(T start, T end) {
        return this.interval.overlaps(start, end);
    }

    public String toString() {
        return "[" + this.interval.start() + ", " + this.interval.end() + "]: " + this.data;
    }

    @Override
    public int compareTo(IntervalObject<T, V> o) {
        return this.interval.compareTo(o.interval);
    }
}

