/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.generics;

import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.container.intervaltree.generics.EmptyIntervalTree;
import edu.sysu.pmglab.container.intervaltree.generics.ImplIntervalTree;
import edu.sysu.pmglab.container.intervaltree.generics.IntervalObject;
import edu.sysu.pmglab.container.list.List;

public interface IntervalTree<T extends Comparable<T>, V>
extends Iterable<IntervalObject<T, V>> {
    public boolean contains(T var1);

    public boolean contains(T var1, T var2);

    default public boolean contains(Interval<T> interval) {
        if (interval == null) {
            return false;
        }
        return this.contains(interval.start(), interval.end());
    }

    public boolean overlaps(T var1, T var2);

    default public boolean overlaps(Interval<T> interval) {
        if (interval == null) {
            return false;
        }
        return this.overlaps(interval.start(), interval.end());
    }

    public List<V> getContains(T var1);

    public List<V> getContains(T var1, T var2);

    default public List<V> getContains(Interval<T> interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getContains(interval.start(), interval.end());
    }

    public List<V> getOverlaps(T var1, T var2);

    default public List<V> getOverlaps(Interval<T> interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getOverlaps(interval.start(), interval.end());
    }

    public List<IntervalObject<T, V>> getIntervalContains(T var1);

    public List<IntervalObject<T, V>> getIntervalContains(T var1, T var2);

    default public List<IntervalObject<T, V>> getIntervalContains(Interval<T> interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getIntervalContains(interval.start(), interval.end());
    }

    public List<IntervalObject<T, V>> getIntervalOverlaps(T var1, T var2);

    default public List<IntervalObject<T, V>> getIntervalOverlaps(Interval<T> interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getIntervalOverlaps(interval.start(), interval.end());
    }

    public Interval<T> getEndpoint();

    public int size();

    public static class Builder<T extends Comparable<T>, V> {
        final List<IntervalObject<T, V>> objects = new List();

        public Builder<T, V> add(IntervalObject<T, V> object) {
            this.objects.add(object);
            return this;
        }

        public Builder<T, V> add(T start, T end, V data) {
            this.objects.add(new IntervalObject<T, V>(start, end, data));
            return this;
        }

        public Builder<T, V> add(Interval<T> interval, V data) {
            this.objects.add(new IntervalObject<T, V>(interval, data));
            return this;
        }

        public IntervalTree<T, V> build() {
            if (this.objects.size() == 0) {
                return new EmptyIntervalTree();
            }
            return new ImplIntervalTree<T, V>(this.objects);
        }
    }
}

