/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.inttree;

import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalNode;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalObject;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;

class ImplIntIntervalTree<T>
implements IntIntervalTree<T> {
    final IntIntervalNode<T> root;
    final List<IntIntervalObject<T>> objects = new List();

    public ImplIntIntervalTree(List<IntIntervalObject<T>> objects) {
        for (IntIntervalObject<T> object : objects) {
            this.objects.add(object);
        }
        this.root = new IntIntervalNode<T>(this.objects);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.root.print(builder, "", "");
        return builder.toString();
    }

    @Override
    public Iterator<IntIntervalObject<T>> iterator() {
        return this.objects.iterator();
    }

    @Override
    public boolean contains(int pos) {
        return this.root.contains(pos);
    }

    @Override
    public boolean contains(int start, int end) {
        if (start == end) {
            return this.contains(start);
        }
        if (start > end) {
            return false;
        }
        return this.root.contains(start, end);
    }

    @Override
    public boolean overlaps(int start, int end) {
        if (start == end) {
            return this.contains(start);
        }
        if (start > end) {
            return false;
        }
        return this.root.overlaps(start, end);
    }

    @Override
    public List<T> getContains(int pos) {
        if (this.contains(pos)) {
            List<IntIntervalObject<IntIntervalObject>> container = new List<IntIntervalObject<IntIntervalObject>>();
            this.root.collectObjectContains(pos, container);
            if (container.size() > 0) {
                container.sort();
                return container.apply(IntIntervalObject::data);
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<T> getContains(int start, int end) {
        if (this.contains(start, end)) {
            List<IntIntervalObject<IntIntervalObject>> container = new List<IntIntervalObject<IntIntervalObject>>();
            this.root.collectObjectContains(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container.apply(IntIntervalObject::data);
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<T> getOverlaps(int start, int end) {
        if (this.overlaps(start, end)) {
            List<IntIntervalObject<IntIntervalObject>> container = new List<IntIntervalObject<IntIntervalObject>>();
            this.root.collectObjectOverlaps(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container.apply(IntIntervalObject::data);
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<IntIntervalObject<T>> getIntervalContains(int pos) {
        if (this.contains(pos)) {
            List container = new List();
            this.root.collectObjectContains(pos, container);
            if (container.size() > 0) {
                container.sort();
                return container;
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<IntIntervalObject<T>> getIntervalContains(int start, int end) {
        if (this.contains(start, end)) {
            List container = new List();
            this.root.collectObjectContains(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container;
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<IntIntervalObject<T>> getIntervalOverlaps(int start, int end) {
        if (this.overlaps(start, end)) {
            List container = new List();
            this.root.collectObjectOverlaps(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container;
            }
        }
        return List.EMPTY();
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public IntInterval getEndpoint() {
        return this.root.getRange();
    }
}

