/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.inttree;

import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalObject;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;

class IntIntervalNode<T> {
    final int center;
    final IntInterval range;
    final IntInterval globalRange;
    final IntIntervalNode<T> left;
    final IntIntervalNode<T> right;
    final List<IntIntervalObject<T>> objects;

    public IntIntervalNode(List<IntIntervalObject<T>> objects) {
        if (objects.size() == 0) {
            throw new IllegalArgumentException();
        }
        IntList endpoints = new IntList(objects.size() << 1);
        for (IntIntervalObject<T> intervalObject : objects) {
            endpoints.add(intervalObject.start());
            endpoints.add(intervalObject.end());
        }
        endpoints.sort();
        this.center = endpoints.get(endpoints.size() / 2);
        List<IntIntervalObject<IntIntervalObject<T>>> left = new List<IntIntervalObject<IntIntervalObject<T>>>(Math.min(objects.size(), 2));
        List<IntIntervalObject<IntIntervalObject<T>>> right = new List<IntIntervalObject<IntIntervalObject<T>>>(Math.min(objects.size(), 2));
        this.objects = new List(Math.min(objects.size(), 2));
        int minPos = Integer.MAX_VALUE;
        int maxPos = Integer.MIN_VALUE;
        int globalMinPos = Integer.MAX_VALUE;
        int globalMaxPos = Integer.MIN_VALUE;
        for (IntIntervalObject<T> object : objects) {
            globalMinPos = Math.min(object.start(), globalMinPos);
            globalMaxPos = Math.max(object.end(), globalMaxPos);
            if (object.end() < this.center) {
                left.add(object);
                continue;
            }
            if (object.start() > this.center) {
                right.add(object);
                continue;
            }
            this.objects.add(object);
            minPos = Math.min(object.start(), minPos);
            maxPos = Math.max(object.end(), maxPos);
        }
        this.range = new IntInterval(minPos, maxPos);
        this.globalRange = new IntInterval(globalMinPos, globalMaxPos);
        this.objects.sort(IntIntervalObject::compareTo);
        this.left = left.size() > 0 ? new IntIntervalNode<T>(left) : null;
        this.right = right.size() > 0 ? new IntIntervalNode<T>(right) : null;
    }

    public boolean contains(int pos) {
        if (this.globalRange.contains(pos)) {
            if (this.range.contains(pos)) {
                return true;
            }
            if (pos < this.center && this.left != null) {
                return this.left.contains(pos);
            }
            if (pos > this.center && this.right != null) {
                return this.right.contains(pos);
            }
        }
        return false;
    }

    public boolean contains(int start, int end) {
        if (this.globalRange.contains(start, end)) {
            if (this.range.contains(start, end)) {
                if (end <= this.center || start >= this.center) {
                    return true;
                }
                for (IntIntervalObject<T> object : this.objects) {
                    if (object.contains(start, end)) {
                        return true;
                    }
                    if (object.start() <= end) continue;
                    break;
                }
            }
            if (end < this.center && this.left != null) {
                return this.left.contains(start, end);
            }
            if (start > this.center && this.right != null) {
                return this.right.contains(start, end);
            }
        }
        return false;
    }

    public boolean overlaps(int start, int end) {
        if (this.globalRange.overlaps(start, end)) {
            boolean overlaps;
            if (this.range.overlaps(start, end)) {
                return true;
            }
            if (start < this.center && this.left != null && (overlaps = this.left.overlaps(start, end))) {
                return true;
            }
            if (end > this.center && this.right != null && (overlaps = this.right.overlaps(start, end))) {
                return true;
            }
        }
        return false;
    }

    public void collectObjectContains(int pos, List<IntIntervalObject<T>> returns) {
        if (this.globalRange.contains(pos)) {
            if (this.range.contains(pos)) {
                for (IntIntervalObject<T> object : this.objects) {
                    if (object.contains(pos)) {
                        returns.add(object);
                        continue;
                    }
                    if (object.start() <= pos) continue;
                    break;
                }
            }
            if (this.globalRange.contains(pos)) {
                if (pos < this.center && this.left != null) {
                    this.left.collectObjectContains(pos, returns);
                } else if (pos > this.center && this.right != null) {
                    this.right.collectObjectContains(pos, returns);
                }
            }
        }
    }

    public void collectObjectContains(int start, int end, List<IntIntervalObject<T>> returns) {
        if (this.globalRange.contains(start, end)) {
            if (this.range.contains(start, end)) {
                for (IntIntervalObject<T> object : this.objects) {
                    if (object.contains(start, end)) {
                        returns.add(object);
                        continue;
                    }
                    if (object.start() <= end) continue;
                    break;
                }
            }
            if (end < this.center && this.left != null) {
                this.left.collectObjectContains(start, end, returns);
            } else if (start > this.center && this.right != null) {
                this.right.collectObjectContains(start, end, returns);
            }
        }
    }

    public void collectObjectOverlaps(int start, int end, List<IntIntervalObject<T>> returns) {
        if (this.globalRange.overlaps(start, end)) {
            if (this.range.overlaps(start, end)) {
                for (IntIntervalObject<T> object : this.objects) {
                    if (object.overlaps(start, end)) {
                        returns.add(object);
                        continue;
                    }
                    if (object.start() <= end) continue;
                    break;
                }
            }
            if (start < this.center && this.left != null) {
                this.left.collectObjectOverlaps(start, end, returns);
            }
            if (end > this.center && this.right != null) {
                this.right.collectObjectOverlaps(start, end, returns);
            }
        }
    }

    public IntInterval getRange() {
        return this.globalRange;
    }

    public void print(StringBuilder buffer, String prefix, String childrenPrefix) {
        buffer.append(prefix);
        buffer.append("Node: " + this.center + " " + this.objects);
        buffer.append("\n");
        if (this.left != null) {
            this.left.print(buffer, childrenPrefix + "\u251c\u2500\u2500 ", childrenPrefix + "\u2502   ");
        }
        if (this.right != null) {
            this.right.print(buffer, childrenPrefix + "\u251c\u2500\u2500 ", childrenPrefix + "\u2502   ");
        }
    }
}

