/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.inttree;

import edu.sysu.pmglab.container.interval.IntInterval;

public class IntIntervalObject<T>
implements Comparable<IntIntervalObject<T>> {
    final T data;
    final IntInterval interval;

    public IntIntervalObject(IntInterval interval, T data) {
        if (interval == null) {
            throw new NullPointerException("null interval");
        }
        this.interval = interval;
        this.data = data;
    }

    public IntIntervalObject(int start, int end, T data) {
        this.interval = new IntInterval(start, end);
        this.data = data;
    }

    public T data() {
        return this.data;
    }

    public int start() {
        return this.interval.start();
    }

    public int end() {
        return this.interval.end();
    }

    public boolean contains(int pos) {
        return this.interval.contains(pos, true);
    }

    public boolean contains(int start, int end) {
        return this.interval.contains(start, end);
    }

    public boolean overlaps(int start, int end) {
        return this.interval.overlaps(start, end);
    }

    public String toString() {
        return "[" + this.interval.start() + ", " + this.interval.end() + "]: " + this.data;
    }

    @Override
    public int compareTo(IntIntervalObject<T> o) {
        return this.interval.compareTo(o.interval);
    }
}

