/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.inttree;

import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.generics.IntervalTree;
import edu.sysu.pmglab.container.intervaltree.inttree.EmptyIntIntervalTree;
import edu.sysu.pmglab.container.intervaltree.inttree.ImplIntIntervalTree;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalObject;
import edu.sysu.pmglab.container.list.List;

public interface IntIntervalTree<T>
extends Iterable<IntIntervalObject<T>> {
    public boolean contains(int var1);

    public boolean contains(int var1, int var2);

    default public boolean contains(IntInterval interval) {
        if (interval == null) {
            return false;
        }
        return this.contains(interval.start(), interval.end());
    }

    public boolean overlaps(int var1, int var2);

    default public boolean overlaps(IntInterval interval) {
        if (interval == null) {
            return false;
        }
        return this.overlaps(interval.start(), interval.end());
    }

    public List<T> getContains(int var1);

    public List<T> getContains(int var1, int var2);

    default public List<T> getContains(IntInterval interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getContains(interval.start(), interval.end());
    }

    public List<T> getOverlaps(int var1, int var2);

    default public List<T> getOverlaps(IntInterval interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getOverlaps(interval.start(), interval.end());
    }

    public List<IntIntervalObject<T>> getIntervalContains(int var1);

    public List<IntIntervalObject<T>> getIntervalContains(int var1, int var2);

    default public List<IntIntervalObject<T>> getIntervalContains(IntInterval interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getIntervalContains(interval.start(), interval.end());
    }

    public List<IntIntervalObject<T>> getIntervalOverlaps(int var1, int var2);

    default public List<IntIntervalObject<T>> getIntervalOverlaps(IntInterval interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getIntervalOverlaps(interval.start(), interval.end());
    }

    public IntInterval getEndpoint();

    public int size();

    default public IntervalTree<Integer, T> toGenericIntervalTree() {
        IntervalTree.Builder builder = new IntervalTree.Builder();
        for (IntIntervalObject intervalObject : this) {
            builder.add(intervalObject.start(), intervalObject.end(), intervalObject.data());
        }
        return builder.build();
    }

    public static class Builder<T> {
        final List<IntIntervalObject<T>> objects = new List();

        public Builder<T> add(IntIntervalObject<T> object) {
            this.objects.add(object);
            return this;
        }

        public Builder<T> add(int start, int end, T data) {
            this.objects.add(new IntIntervalObject<T>(start, end, data));
            return this;
        }

        public Builder<T> add(IntInterval interval, T data) {
            this.objects.add(new IntIntervalObject<T>(interval, data));
            return this;
        }

        public IntIntervalTree<T> build() {
            if (this.objects.size() == 0) {
                return EmptyIntIntervalTree.INSTANCE;
            }
            return new ImplIntIntervalTree<T>(this.objects);
        }
    }
}

