/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.longtree;

import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.longtree.LongIntervalNode;
import edu.sysu.pmglab.container.intervaltree.longtree.LongIntervalObject;
import edu.sysu.pmglab.container.intervaltree.longtree.LongIntervalTree;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;

class ImplLongIntervalTree<T>
implements LongIntervalTree<T> {
    final LongIntervalNode<T> root;
    final List<LongIntervalObject<T>> objects = new List();

    public ImplLongIntervalTree(List<LongIntervalObject<T>> objects) {
        for (LongIntervalObject<T> object : objects) {
            this.objects.add(object);
        }
        this.root = new LongIntervalNode<T>(this.objects);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.root.print(builder, "", "");
        return builder.toString();
    }

    @Override
    public Iterator<LongIntervalObject<T>> iterator() {
        return this.objects.iterator();
    }

    @Override
    public boolean contains(long pos) {
        return this.root.contains(pos);
    }

    @Override
    public boolean contains(long start, long end) {
        if (start == end) {
            return this.contains(start);
        }
        if (start > end) {
            return false;
        }
        return this.root.contains(start, end);
    }

    @Override
    public boolean overlaps(long start, long end) {
        if (start == end) {
            return this.contains(start);
        }
        if (start > end) {
            return false;
        }
        return this.root.overlaps(start, end);
    }

    @Override
    public T getSingletonContains(long pos) {
        if (this.contains(pos)) {
            return this.root.collectSingletonContains((long)pos).data;
        }
        return null;
    }

    @Override
    public List<T> getContains(long pos) {
        if (this.contains(pos)) {
            List<LongIntervalObject<LongIntervalObject>> container = new List<LongIntervalObject<LongIntervalObject>>();
            this.root.collectObjectContains(pos, container);
            if (container.size() > 0) {
                container.sort();
                return container.apply(LongIntervalObject::data);
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<T> getContains(long start, long end) {
        if (this.contains(start, end)) {
            List<LongIntervalObject<LongIntervalObject>> container = new List<LongIntervalObject<LongIntervalObject>>();
            this.root.collectObjectContains(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container.apply(LongIntervalObject::data);
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<T> getOverlaps(long start, long end) {
        if (this.overlaps(start, end)) {
            List<LongIntervalObject<LongIntervalObject>> container = new List<LongIntervalObject<LongIntervalObject>>();
            this.root.collectObjectOverlaps(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container.apply(LongIntervalObject::data);
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<LongIntervalObject<T>> getIntervalContains(long pos) {
        if (this.contains(pos)) {
            List container = new List();
            this.root.collectObjectContains(pos, container);
            if (container.size() > 0) {
                container.sort();
                return container;
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<LongIntervalObject<T>> getIntervalContains(long start, long end) {
        if (this.contains(start, end)) {
            List container = new List();
            this.root.collectObjectContains(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container;
            }
        }
        return List.EMPTY();
    }

    @Override
    public List<LongIntervalObject<T>> getIntervalOverlaps(long start, long end) {
        if (this.overlaps(start, end)) {
            List container = new List();
            this.root.collectObjectOverlaps(start, end, container);
            if (container.size() > 0) {
                container.sort();
                return container;
            }
        }
        return List.EMPTY();
    }

    @Override
    public LongInterval getEndpoint() {
        return this.root.getRange();
    }

    @Override
    public int size() {
        return this.objects.size();
    }
}

