/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.longtree;

import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.longtree.LongIntervalObject;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.LongList;

class LongIntervalNode<T> {
    final long center;
    final LongInterval range;
    final LongInterval globalRange;
    final LongIntervalNode<T> left;
    final LongIntervalNode<T> right;
    final List<LongIntervalObject<T>> objects;

    public LongIntervalNode(List<LongIntervalObject<T>> objects) {
        if (objects.size() == 0) {
            throw new IllegalArgumentException();
        }
        LongList endpoints = new LongList(objects.size() << 1);
        for (LongIntervalObject<T> intervalObject : objects) {
            endpoints.add(intervalObject.start());
            endpoints.add(intervalObject.end());
        }
        endpoints.sort();
        this.center = endpoints.get(endpoints.size() / 2);
        List<LongIntervalObject<LongIntervalObject<T>>> left = new List<LongIntervalObject<LongIntervalObject<T>>>(Math.min(objects.size(), 2));
        List<LongIntervalObject<LongIntervalObject<T>>> right = new List<LongIntervalObject<LongIntervalObject<T>>>(Math.min(objects.size(), 2));
        this.objects = new List(Math.min(objects.size(), 2));
        long minPos = Long.MAX_VALUE;
        long maxPos = Long.MIN_VALUE;
        long globalMinPos = Long.MAX_VALUE;
        long globalMaxPos = Long.MIN_VALUE;
        for (LongIntervalObject<T> object : objects) {
            globalMinPos = Math.min(object.start(), globalMinPos);
            globalMaxPos = Math.max(object.end(), globalMaxPos);
            if (object.end() < this.center) {
                left.add(object);
                continue;
            }
            if (object.start() > this.center) {
                right.add(object);
                continue;
            }
            this.objects.add(object);
            minPos = Math.min(object.start(), minPos);
            maxPos = Math.max(object.end(), maxPos);
        }
        this.range = new LongInterval(minPos, maxPos);
        this.globalRange = new LongInterval(globalMinPos, globalMaxPos);
        this.objects.sort(LongIntervalObject::compareTo);
        this.left = left.size() > 0 ? new LongIntervalNode<T>(left) : null;
        this.right = right.size() > 0 ? new LongIntervalNode<T>(right) : null;
    }

    public boolean contains(long pos) {
        if (this.globalRange.contains(pos)) {
            if (this.range.contains(pos)) {
                return true;
            }
            if (pos < this.center && this.left != null) {
                return this.left.contains(pos);
            }
            if (pos > this.center && this.right != null) {
                return this.right.contains(pos);
            }
        }
        return false;
    }

    public boolean contains(long start, long end) {
        if (this.globalRange.contains(start, end)) {
            if (this.range.contains(start, end)) {
                if (end <= this.center || start >= this.center) {
                    return true;
                }
                for (LongIntervalObject<T> object : this.objects) {
                    if (object.contains(start, end)) {
                        return true;
                    }
                    if (object.start() <= end) continue;
                    break;
                }
            }
            if (end < this.center && this.left != null) {
                return this.left.contains(start, end);
            }
            if (start > this.center && this.right != null) {
                return this.right.contains(start, end);
            }
        }
        return false;
    }

    public boolean overlaps(long start, long end) {
        if (this.globalRange.overlaps(start, end)) {
            boolean overlaps;
            if (this.range.overlaps(start, end)) {
                return true;
            }
            if (start < this.center && this.left != null && (overlaps = this.left.overlaps(start, end))) {
                return true;
            }
            if (end > this.center && this.right != null && (overlaps = this.right.overlaps(start, end))) {
                return true;
            }
        }
        return false;
    }

    public void collectObjectContains(long pos, List<LongIntervalObject<T>> returns) {
        if (this.globalRange.contains(pos)) {
            if (this.range.contains(pos)) {
                for (LongIntervalObject<T> object : this.objects) {
                    if (object.contains(pos)) {
                        returns.add(object);
                        continue;
                    }
                    if (object.start() <= pos) continue;
                    break;
                }
            }
            if (this.globalRange.contains(pos)) {
                if (pos < this.center && this.left != null) {
                    this.left.collectObjectContains(pos, returns);
                } else if (pos > this.center && this.right != null) {
                    this.right.collectObjectContains(pos, returns);
                }
            }
        }
    }

    public LongIntervalObject<T> collectSingletonContains(long pos) {
        if (this.globalRange.contains(pos)) {
            if (this.range.contains(pos)) {
                for (LongIntervalObject<T> object : this.objects) {
                    if (object.contains(pos)) {
                        return object;
                    }
                    if (object.start() <= pos) continue;
                    break;
                }
            }
            if (this.globalRange.contains(pos)) {
                if (pos < this.center && this.left != null) {
                    return this.left.collectSingletonContains(pos);
                }
                if (pos > this.center && this.right != null) {
                    return this.right.collectSingletonContains(pos);
                }
            }
        }
        return null;
    }

    public void collectObjectContains(long start, long end, List<LongIntervalObject<T>> returns) {
        if (this.globalRange.contains(start, end)) {
            if (this.range.contains(start, end)) {
                for (LongIntervalObject<T> object : this.objects) {
                    if (object.contains(start, end)) {
                        returns.add(object);
                        continue;
                    }
                    if (object.start() <= end) continue;
                    break;
                }
            }
            if (end < this.center && this.left != null) {
                this.left.collectObjectContains(start, end, returns);
            } else if (start > this.center && this.right != null) {
                this.right.collectObjectContains(start, end, returns);
            }
        }
    }

    public void collectObjectOverlaps(long start, long end, List<LongIntervalObject<T>> returns) {
        if (this.globalRange.overlaps(start, end)) {
            if (this.range.overlaps(start, end)) {
                for (LongIntervalObject<T> object : this.objects) {
                    if (object.overlaps(start, end)) {
                        returns.add(object);
                        continue;
                    }
                    if (object.start() <= end) continue;
                    break;
                }
            }
            if (start < this.center && this.left != null) {
                this.left.collectObjectOverlaps(start, end, returns);
            }
            if (end > this.center && this.right != null) {
                this.right.collectObjectOverlaps(start, end, returns);
            }
        }
    }

    public LongInterval getRange() {
        return this.globalRange;
    }

    public void print(StringBuilder buffer, String prefix, String childrenPrefix) {
        buffer.append(prefix);
        buffer.append("Node: " + this.center + " " + this.objects);
        buffer.append("\n");
        if (this.left != null) {
            this.left.print(buffer, childrenPrefix + "\u251c\u2500\u2500 ", childrenPrefix + "\u2502   ");
        }
        if (this.right != null) {
            this.right.print(buffer, childrenPrefix + "\u251c\u2500\u2500 ", childrenPrefix + "\u2502   ");
        }
    }
}

