/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.longtree;

import edu.sysu.pmglab.container.interval.LongInterval;

public class LongIntervalObject<T>
implements Comparable<LongIntervalObject<T>> {
    final T data;
    final LongInterval interval;

    public LongIntervalObject(LongInterval interval, T data) {
        if (interval == null) {
            throw new NullPointerException("null interval");
        }
        this.interval = interval;
        this.data = data;
    }

    public LongIntervalObject(long start, long end, T data) {
        this.interval = new LongInterval(start, end);
        this.data = data;
    }

    public T data() {
        return this.data;
    }

    public long start() {
        return this.interval.start();
    }

    public long end() {
        return this.interval.end();
    }

    public boolean contains(long pos) {
        return this.interval.contains(pos, true);
    }

    public boolean contains(long start, long end) {
        return this.interval.contains(start, end);
    }

    public boolean overlaps(long start, long end) {
        return this.interval.overlaps(start, end);
    }

    public String toString() {
        return "[" + this.interval.start() + ", " + this.interval.end() + "]: " + this.data;
    }

    @Override
    public int compareTo(LongIntervalObject<T> o) {
        return this.interval.compareTo(o.interval);
    }
}

