/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.intervaltree.longtree;

import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.generics.IntervalTree;
import edu.sysu.pmglab.container.intervaltree.longtree.EmptyLongIntervalTree;
import edu.sysu.pmglab.container.intervaltree.longtree.ImplLongIntervalTree;
import edu.sysu.pmglab.container.intervaltree.longtree.LongIntervalObject;
import edu.sysu.pmglab.container.list.List;

public interface LongIntervalTree<T>
extends Iterable<LongIntervalObject<T>> {
    public boolean contains(long var1);

    public boolean contains(long var1, long var3);

    default public boolean contains(LongInterval interval) {
        if (interval == null) {
            return false;
        }
        return this.contains(interval.start(), interval.end());
    }

    public boolean overlaps(long var1, long var3);

    default public boolean overlaps(LongInterval interval) {
        if (interval == null) {
            return false;
        }
        return this.overlaps(interval.start(), interval.end());
    }

    public T getSingletonContains(long var1);

    public List<T> getContains(long var1);

    public List<T> getContains(long var1, long var3);

    default public List<T> getContains(LongInterval interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getContains(interval.start(), interval.end());
    }

    public List<T> getOverlaps(long var1, long var3);

    default public List<T> getOverlaps(LongInterval interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getOverlaps(interval.start(), interval.end());
    }

    public List<LongIntervalObject<T>> getIntervalContains(long var1);

    public List<LongIntervalObject<T>> getIntervalContains(long var1, long var3);

    default public List<LongIntervalObject<T>> getIntervalContains(LongInterval interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getIntervalContains(interval.start(), interval.end());
    }

    public List<LongIntervalObject<T>> getIntervalOverlaps(long var1, long var3);

    default public List<LongIntervalObject<T>> getIntervalOverlaps(LongInterval interval) {
        if (interval == null) {
            return List.EMPTY();
        }
        return this.getIntervalOverlaps(interval.start(), interval.end());
    }

    public LongInterval getEndpoint();

    public int size();

    default public IntervalTree<Long, T> toGenericIntervalTree() {
        IntervalTree.Builder builder = new IntervalTree.Builder();
        for (LongIntervalObject intervalObject : this) {
            builder.add(intervalObject.start(), intervalObject.end(), intervalObject.data());
        }
        return builder.build();
    }

    public static class Builder<T> {
        final List<LongIntervalObject<T>> objects = new List();

        public Builder<T> add(LongIntervalObject<T> object) {
            this.objects.add(object);
            return this;
        }

        public Builder<T> add(long start, long end, T data) {
            this.objects.add(new LongIntervalObject<T>(start, end, data));
            return this;
        }

        public Builder<T> add(LongInterval interval, T data) {
            this.objects.add(new LongIntervalObject<T>(interval, data));
            return this;
        }

        public LongIntervalTree<T> build() {
            if (this.objects.size() == 0) {
                return EmptyLongIntervalTree.INSTANCE;
            }
            return new ImplLongIntervalTree<T>(this.objects);
        }
    }
}

