/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.iterator;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.iterator.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterIterator<T>
implements Iterator<T> {
    final Iterator<T> iterator;
    final IFilter<T> filter;
    T nextElement;
    boolean hasNextElement;

    public FilterIterator(Iterable<T> iterable, IFilter<T> filter) {
        this.iterator = iterable == null ? EmptyIterator.INSTANCE() : iterable.iterator();
        this.filter = filter;
        this.fetchNext();
    }

    public FilterIterator(Iterator<T> iterator2, IFilter<T> filter) {
        this.iterator = iterator2 == null ? EmptyIterator.INSTANCE() : iterator2;
        this.filter = filter;
        this.fetchNext();
    }

    private void fetchNext() {
        this.hasNextElement = false;
        this.nextElement = null;
        while (this.iterator.hasNext()) {
            T element = this.iterator.next();
            if (this.filter != null && !this.filter.filter(element)) continue;
            this.nextElement = element;
            this.hasNextElement = true;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNextElement;
    }

    @Override
    public T next() {
        if (!this.hasNextElement) {
            throw new NoSuchElementException();
        }
        T result = this.nextElement;
        this.fetchNext();
        return result;
    }
}

