/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class SingletonIterator<V>
implements Iterator<V> {
    final V element;
    private volatile boolean hasNext = true;

    public SingletonIterator(V element) {
        this.element = element;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public V next() {
        if (this.hasNext) {
            try {
                V v = this.element;
                return v;
            }
            finally {
                this.hasNext = false;
            }
        }
        throw new NoSuchElementException();
    }
}

