/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.list;

import edu.sysu.pmglab.ccf.toolkit.filter.IByteFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.function.TByteFunction;
import gnu.trove.iterator.TByteIterator;
import gnu.trove.set.TByteSet;
import gnu.trove.set.hash.TByteHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class ByteList {
    byte[] cache;
    int start = 0;
    int end = 0;

    public ByteList() {
        this(4);
    }

    public ByteList(int initialCapacity) {
        if (initialCapacity == 0) {
            this.cache = EmptyArray.BYTE;
        } else {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this.cache = new byte[initialCapacity];
        }
    }

    public ByteList(byte[] values2) {
        this(values2, 0, values2.length);
    }

    public ByteList(byte[] values2, int offset, int length) {
        this.cache = new byte[values2.length];
        System.arraycopy(values2, offset, this.cache, 0, length);
        this.end = length;
    }

    public ByteList(Byte[] values2) {
        this.cache = new byte[values2.length];
        for (Byte value : values2) {
            if (value == null) continue;
            this.cache[this.end++] = value;
        }
    }

    public ByteList(Iterable<Byte> values2) {
        this.cache = new byte[4];
        for (Byte value : values2) {
            if (value == null) continue;
            this.add(value);
        }
    }

    public ByteList(TByteIterator values2) {
        this.cache = new byte[4];
        while (values2.hasNext()) {
            this.add(values2.next());
        }
    }

    public static ByteList wrap(byte ... src) {
        if (src == null || src.length == 0) {
            return new ByteList(0);
        }
        return ByteList.wrap(src, 0, src.length);
    }

    public static ByteList wrap(byte[] src, int offset, int length) {
        Assert.that(src != null);
        Assert.that(offset >= 0 && offset <= src.length);
        Assert.that(length >= 0 && offset + length <= src.length);
        ByteList array = new ByteList(0);
        array.cache = src;
        array.start = offset;
        array.end = offset + length;
        return array;
    }

    public byte popFirst() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            byte by = this.fastGet(0);
            return by;
        }
        finally {
            ++this.start;
        }
    }

    public byte popLast() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            byte by = this.fastLastGet(0);
            return by;
        }
        finally {
            --this.end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteList popFirst(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                ByteList returns = new ByteList(size);
                for (int i = 0; i < size; ++i) {
                    returns.add(this.fastGet(i));
                }
                ByteList byteList = returns;
                return byteList;
            }
            ByteList byteList = null;
            return byteList;
        }
        finally {
            this.start += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteList popLast(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                ByteList returns = new ByteList(size);
                for (int i = size - 1; i >= 0; --i) {
                    returns.add(this.fastLastGet(i));
                }
                ByteList byteList = returns;
                return byteList;
            }
            ByteList byteList = null;
            return byteList;
        }
        finally {
            this.end -= size;
        }
    }

    private void checkCapacity(int writeSize) {
        this.expansion(writeSize - (this.cache.length - this.end));
    }

    private void expansion(long requestSize) {
        if (requestSize > 0L) {
            long newSize = requestSize + (long)(this.cache.length - this.start);
            if (newSize <= (long)this.cache.length) {
                int index = 0;
                int l = this.size();
                for (int i = 0; i < l; ++i) {
                    this.cache[index++] = this.fastGet(i);
                }
                this.start = 0;
                this.end = index;
                return;
            }
            if (newSize >= 0x7FFFFFFDL) {
                throw new OutOfMemoryError("Requested array size exceeds VM limit");
            }
            newSize = newSize < 16L ? 16L : (newSize <= 0x7FFFFFFL ? (newSize <<= 1) : ValueUtils.valueOf(newSize + (newSize >> 1), 0L, 0x7FFFFFFDL));
            byte[] newCache = new byte[(int)newSize];
            System.arraycopy(this.cache, this.start, newCache, 0, this.size());
            this.end -= this.start;
            this.start = 0;
            this.cache = newCache;
        }
    }

    public byte[] toArray() {
        if (this.size() == 0) {
            return EmptyArray.BYTE;
        }
        return Arrays.copyOfRange(this.cache, this.start, this.end);
    }

    public byte[] toArray(byte[] dest) {
        if (dest.length < this.size()) {
            return Arrays.copyOfRange(this.cache, this.start, this.end);
        }
        System.arraycopy(this.cache, 0, dest, 0, this.size());
        if (dest.length > this.size()) {
            dest[this.size()] = 0;
        }
        return dest;
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(byte element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return true;
        }
        return false;
    }

    public TByteIterator iterator() {
        return new TByteIterator(){
            final int size;
            int pointer;
            {
                this.size = ByteList.this.size();
                this.pointer = 0;
            }

            @Override
            public byte next() {
                return ByteList.this.fastGet(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < this.size;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean add(byte element) {
        this.checkCapacity(1);
        this.cache[this.end++] = element;
        return true;
    }

    public boolean remove(byte element) {
        boolean anyRemove = false;
        if (this.size() > 0) {
            int index = 0;
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                byte value = this.fastGet(i);
                if (element != value) {
                    this.cache[index++] = value;
                    continue;
                }
                anyRemove = true;
            }
            this.start = 0;
            this.end = index;
        }
        return anyRemove;
    }

    public void clear() {
        this.start = 0;
        this.end = 0;
    }

    public byte removeByIndex(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        int size = this.size();
        byte value = this.fastGet(index);
        if (index == 0) {
            ++this.start;
        } else if (index == size - 1) {
            --this.end;
        } else if (index < size / 2) {
            for (int ind = this.start + index; ind >= this.start + 1; --ind) {
                this.cache[ind] = this.cache[ind - 1];
            }
            ++this.start;
        } else {
            for (int ind = this.start + index; ind < this.end - 1; ++ind) {
                this.cache[ind] = this.cache[ind + 1];
            }
            --this.end;
        }
        return value;
    }

    public boolean insert(int index, byte value) {
        if (index < 0 || this.start + index > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.checkCapacity(1);
        if (this.start > 0) {
            int l = this.start + index;
            for (int i = this.start; i < l; ++i) {
                this.cache[i - 1] = this.fastGet(i);
            }
            --this.start;
        } else {
            int l = this.start + index;
            for (int i = this.end - 1; i >= l; --i) {
                this.cache[i + 1] = this.fastGet(i);
            }
            ++this.end;
        }
        this.cache[this.start + index] = value;
        return true;
    }

    public boolean addAll(byte[] elements) {
        return this.addAll(elements, 0, elements.length);
    }

    public boolean addAll(byte[] elements, int offset, int length) {
        Assert.that(elements != null);
        Assert.that(offset >= 0 && offset <= elements.length);
        Assert.that(length >= 0 && offset + length <= elements.length);
        this.checkCapacity(length);
        for (int i = offset; i < offset + length; ++i) {
            this.cache[this.end++] = elements[i];
        }
        return true;
    }

    public boolean addAll(ByteList values2) {
        Assert.that(values2 != null);
        this.checkCapacity(values2.size());
        boolean addAnyValue = false;
        int l = values2.size();
        for (int i = 0; i < l; ++i) {
            this.cache[this.end++] = values2.fastGet(i);
            addAnyValue = true;
        }
        return addAnyValue;
    }

    public ByteList subList(int fromIndex, int toIndex) {
        Assert.that(fromIndex >= 0 && fromIndex <= this.size());
        Assert.that(toIndex >= 0 && toIndex <= this.size());
        Assert.that(fromIndex <= toIndex);
        return ByteList.wrap(this.cache, this.start + fromIndex, toIndex - fromIndex);
    }

    public boolean removeIf(IByteFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            byte value = this.fastGet(i);
            if (condition.filter(value)) {
                change = true;
                continue;
            }
            this.cache[index++] = value;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public boolean retainIf(IByteFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            byte value = this.fastGet(i);
            if (condition.filter(value)) {
                this.cache[index++] = value;
                continue;
            }
            change = true;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public byte fastGet(int index) {
        return this.cache[this.start + index];
    }

    public byte fastLastGet(int index) {
        return this.cache[this.end - index - 1];
    }

    public byte fastSet(int index, byte newValue) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.cache[this.start + index] = newValue;
        return newValue;
    }

    public byte get(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        return this.fastGet(index);
    }

    public byte lastGet(int index) {
        return this.get(this.size() - 1 - index);
    }

    public byte set(int index, byte newValue) {
        if (index == this.size()) {
            this.add(newValue);
        } else {
            if (index < 0 || this.start + index >= this.end) {
                throw new ArrayIndexOutOfBoundsException("Index out of bounds");
            }
            this.cache[this.start + index] = newValue;
        }
        return newValue;
    }

    public byte lastSet(int index, byte newValue) {
        return this.set(this.end - index - 1, newValue);
    }

    public int hashCode() {
        int hashCode = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            hashCode = 31 * hashCode + Byte.hashCode(this.fastGet(i));
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteList)) {
            return false;
        }
        ByteList array = (ByteList)o;
        if (this.cache == array.cache && this.start == array.start && this.end == array.end) {
            return true;
        }
        if (array.size() != this.size()) {
            return false;
        }
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (this.fastGet(i) == array.fastGet(i)) continue;
            return false;
        }
        return true;
    }

    public ByteList clone() {
        return new ByteList(this.cache, this.start, this.size());
    }

    public String toString() {
        TByteIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            byte e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public void dropDuplicates() {
        if (this.size() <= 1) {
            return;
        }
        TByteHashSet existsElements = new TByteHashSet();
        int index = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            byte element = this.fastGet(i);
            if (existsElements.contains(element)) continue;
            existsElements.add(element);
            this.cache[index++] = element;
        }
        existsElements.clear();
        this.start = 0;
        this.end = index;
    }

    public void fill(byte value, int size) {
        if (size > 0) {
            this.checkCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.cache[this.end++] = value;
            }
        }
    }

    public void close() {
        this.start = 0;
        this.end = 0;
        this.cache = EmptyArray.BYTE;
    }

    public int binarySearch(byte key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = this.cache[this.start + mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int argmax() {
        if (this.size() == 0) {
            return -1;
        }
        byte element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (element >= this.fastGet(i)) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.size() == 0) {
            return -1;
        }
        byte element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (element <= this.fastGet(i)) continue;
            index = i;
        }
        return index;
    }

    public byte max() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        byte maxValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (maxValue >= this.fastGet(i)) continue;
            maxValue = this.fastGet(i);
        }
        return maxValue;
    }

    public byte min() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        byte minValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (minValue <= this.fastGet(i)) continue;
            minValue = this.fastGet(i);
        }
        return minValue;
    }

    public boolean all(IByteFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (rule.filter(this.fastGet(i))) continue;
            return false;
        }
        return true;
    }

    public boolean any(IByteFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            return true;
        }
        return false;
    }

    public int count(IByteFilter rule) {
        int count = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            ++count;
        }
        return count;
    }

    public TByteSet toSet() {
        TByteHashSet container = new TByteHashSet(this.size());
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            container.add(this.fastGet(i));
        }
        return container;
    }

    public TByteSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(IByteFilter function) {
        return new IndexIterator(this.size(), function == null ? null : index -> function.filter(this.fastGet(index)));
    }

    public ByteList apply(TByteFunction function) {
        return this.apply(function, null);
    }

    public ByteList apply(TByteFunction function, IByteFilter filter) {
        ByteList result = new ByteList(this.size());
        if (filter != null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                byte value = function.execute(this.fastGet(i));
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                result.add(function.execute(this.fastGet(i)));
            }
        }
        return result;
    }

    public void applyInplace(TByteFunction function) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            this.cache[i] = function.execute(this.fastGet(i));
        }
        this.end = l;
        this.start = 0;
    }

    public ByteList filter(IByteFilter filter) {
        ByteList result = new ByteList(1);
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            byte c = this.fastGet(i);
            if (!filter.filter(c)) continue;
            result.add(c);
        }
        return result;
    }

    public void sort(int beginIndex, int endIndex) {
        Assert.that(beginIndex >= 0 && beginIndex <= this.size());
        Assert.that(endIndex >= beginIndex && endIndex <= this.size());
        Arrays.sort(this.cache, this.start + beginIndex, this.start + endIndex);
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public int indexOf(byte element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(IByteFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastGet(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastLastGet(i)) continue;
            return l - i - 1;
        }
        return -1;
    }

    public int lastIndexOfIf(IByteFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastLastGet(i))) continue;
            return l - i - 1;
        }
        return -1;
    }

    public String toString(String joiner) {
        TByteIterator it = this.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            byte e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.toString();
            }
            sb.append(joiner);
        }
    }

    public ByteList asUnmodifiable() {
        return new ByteList(){
            {
                this.cache = ByteList.this.cache;
                this.start = ByteList.this.start;
                this.end = ByteList.this.end;
            }

            @Override
            public byte popFirst() {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte popLast() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ByteList popFirst(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ByteList popLast(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(byte element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(byte element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte removeByIndex(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean insert(int index, byte value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(byte[] elements) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(byte[] elements, int offset, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(ByteList values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(IByteFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainIf(IByteFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte fastSet(int index, byte newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte set(int index, byte newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte lastSet(int index, byte newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void dropDuplicates() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void applyInplace(TByteFunction function) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort(int beginIndex, int endIndex) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ByteList asUnmodifiable() {
                return this;
            }

            @Override
            public void shuffle(long seed) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.end - 1; i > this.start; --i) {
            int j = this.start + random.nextInt(i - this.start + 1);
            byte temp = this.cache[i];
            this.cache[i] = this.cache[j];
            this.cache[j] = temp;
        }
    }
}

