/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.list;

import edu.sysu.pmglab.ccf.toolkit.filter.IDoubleFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.function.TDoubleFunction;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.set.TDoubleSet;
import gnu.trove.set.hash.TDoubleHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class DoubleList {
    double[] cache;
    int start = 0;
    int end = 0;

    public DoubleList() {
        this(4);
    }

    public DoubleList(int initialCapacity) {
        if (initialCapacity == 0) {
            this.cache = EmptyArray.DOUBLE;
        } else {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this.cache = new double[initialCapacity];
        }
    }

    public DoubleList(double[] values2) {
        this(values2, 0, values2.length);
    }

    public DoubleList(double[] values2, int offset, int length) {
        this.cache = new double[values2.length];
        System.arraycopy(values2, offset, this.cache, 0, length);
        this.end = length;
    }

    public DoubleList(Double[] values2) {
        this.cache = new double[values2.length];
        for (Double value : values2) {
            if (value == null) continue;
            this.cache[this.end++] = value;
        }
    }

    public DoubleList(Iterable<Double> values2) {
        this.cache = new double[4];
        for (Double value : values2) {
            if (value == null) continue;
            this.add(value);
        }
    }

    public DoubleList(TDoubleIterator values2) {
        this.cache = new double[4];
        while (values2.hasNext()) {
            this.add(values2.next());
        }
    }

    public static DoubleList wrap(double ... src) {
        if (src == null || src.length == 0) {
            return new DoubleList(0);
        }
        return DoubleList.wrap(src, 0, src.length);
    }

    public static DoubleList wrap(double[] src, int offset, int length) {
        Assert.that(src != null);
        Assert.that(offset >= 0 && offset <= src.length);
        Assert.that(length >= 0 && offset + length <= src.length);
        DoubleList array = new DoubleList(0);
        array.cache = src;
        array.start = offset;
        array.end = offset + length;
        return array;
    }

    public double popFirst() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            double d = this.fastGet(0);
            return d;
        }
        finally {
            ++this.start;
        }
    }

    public double popLast() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            double d = this.fastLastGet(0);
            return d;
        }
        finally {
            --this.end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleList popFirst(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                DoubleList returns = new DoubleList(size);
                for (int i = 0; i < size; ++i) {
                    returns.add(this.fastGet(i));
                }
                DoubleList doubleList = returns;
                return doubleList;
            }
            DoubleList doubleList = null;
            return doubleList;
        }
        finally {
            this.start += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleList popLast(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                DoubleList returns = new DoubleList(size);
                for (int i = size - 1; i >= 0; --i) {
                    returns.add(this.fastLastGet(i));
                }
                DoubleList doubleList = returns;
                return doubleList;
            }
            DoubleList doubleList = null;
            return doubleList;
        }
        finally {
            this.end -= size;
        }
    }

    private void checkCapacity(int writeSize) {
        this.expansion(writeSize - (this.cache.length - this.end));
    }

    private void expansion(long requestSize) {
        if (requestSize > 0L) {
            long newSize = requestSize + (long)(this.cache.length - this.start);
            if (newSize <= (long)this.cache.length) {
                int index = 0;
                int l = this.size();
                for (int i = 0; i < l; ++i) {
                    this.cache[index++] = this.fastGet(i);
                }
                this.start = 0;
                this.end = index;
                return;
            }
            if (newSize >= 0x7FFFFFFDL) {
                throw new OutOfMemoryError("Requested array size exceeds VM limit");
            }
            newSize = newSize < 16L ? 16L : (newSize <= 0x7FFFFFFL ? (newSize <<= 1) : ValueUtils.valueOf(newSize + (newSize >> 1), 0L, 0x7FFFFFFDL));
            double[] newCache = new double[(int)newSize];
            System.arraycopy(this.cache, this.start, newCache, 0, this.size());
            this.end -= this.start;
            this.start = 0;
            this.cache = newCache;
        }
    }

    public double[] toArray() {
        if (this.size() == 0) {
            return EmptyArray.DOUBLE;
        }
        return Arrays.copyOfRange(this.cache, this.start, this.end);
    }

    public double[] toArray(double[] dest) {
        if (dest.length < this.size()) {
            return Arrays.copyOfRange(this.cache, this.start, this.end);
        }
        System.arraycopy(this.cache, 0, dest, 0, this.size());
        if (dest.length > this.size()) {
            dest[this.size()] = 0.0;
        }
        return dest;
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(double element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return true;
        }
        return false;
    }

    public TDoubleIterator iterator() {
        return new TDoubleIterator(){
            final int size;
            int pointer;
            {
                this.size = DoubleList.this.size();
                this.pointer = 0;
            }

            @Override
            public double next() {
                return DoubleList.this.fastGet(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < this.size;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean add(double element) {
        this.checkCapacity(1);
        this.cache[this.end++] = element;
        return true;
    }

    public boolean remove(double element) {
        boolean anyRemove = false;
        if (this.size() > 0) {
            int index = 0;
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                double value = this.fastGet(i);
                if (element != value) {
                    this.cache[index++] = value;
                    continue;
                }
                anyRemove = true;
            }
            this.start = 0;
            this.end = index;
        }
        return anyRemove;
    }

    public void clear() {
        this.start = 0;
        this.end = 0;
    }

    public double removeByIndex(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        int size = this.size();
        double value = this.fastGet(index);
        if (index == 0) {
            ++this.start;
        } else if (index == size - 1) {
            --this.end;
        } else if (index < size / 2) {
            for (int ind = this.start + index; ind >= this.start + 1; --ind) {
                this.cache[ind] = this.cache[ind - 1];
            }
            ++this.start;
        } else {
            for (int ind = this.start + index; ind < this.end - 1; ++ind) {
                this.cache[ind] = this.cache[ind + 1];
            }
            --this.end;
        }
        return value;
    }

    public boolean insert(int index, double value) {
        if (index < 0 || this.start + index > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.checkCapacity(1);
        if (this.start > 0) {
            int l = this.start + index;
            for (int i = this.start; i < l; ++i) {
                this.cache[i - 1] = this.fastGet(i);
            }
            --this.start;
        } else {
            int l = this.start + index;
            for (int i = this.end - 1; i >= l; --i) {
                this.cache[i + 1] = this.fastGet(i);
            }
            ++this.end;
        }
        this.cache[this.start + index] = value;
        return true;
    }

    public boolean addAll(double[] elements) {
        return this.addAll(elements, 0, elements.length);
    }

    public boolean addAll(double[] elements, int offset, int length) {
        Assert.that(elements != null);
        Assert.that(offset >= 0 && offset <= elements.length);
        Assert.that(length >= 0 && offset + length <= elements.length);
        this.checkCapacity(length);
        for (int i = offset; i < offset + length; ++i) {
            this.cache[this.end++] = elements[i];
        }
        return true;
    }

    public boolean addAll(DoubleList values2) {
        Assert.that(values2 != null);
        this.checkCapacity(values2.size());
        boolean addAnyValue = false;
        int l = values2.size();
        for (int i = 0; i < l; ++i) {
            this.cache[this.end++] = values2.fastGet(i);
            addAnyValue = true;
        }
        return addAnyValue;
    }

    public DoubleList subList(int fromIndex, int toIndex) {
        Assert.that(fromIndex >= 0 && fromIndex <= this.size());
        Assert.that(toIndex >= 0 && toIndex <= this.size());
        Assert.that(fromIndex <= toIndex);
        return DoubleList.wrap(this.cache, this.start + fromIndex, toIndex - fromIndex);
    }

    public boolean removeIf(IDoubleFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            double value = this.fastGet(i);
            if (condition.filter(value)) {
                change = true;
                continue;
            }
            this.cache[index++] = value;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public boolean retainIf(IDoubleFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            double value = this.fastGet(i);
            if (condition.filter(value)) {
                this.cache[index++] = value;
                continue;
            }
            change = true;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public double fastGet(int index) {
        return this.cache[this.start + index];
    }

    public double fastLastGet(int index) {
        return this.cache[this.end - index - 1];
    }

    public double fastSet(int index, double newValue) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.cache[this.start + index] = newValue;
        return newValue;
    }

    public double get(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        return this.fastGet(index);
    }

    public double lastGet(int index) {
        return this.get(this.size() - 1 - index);
    }

    public double set(int index, double newValue) {
        if (index == this.size()) {
            this.add(newValue);
        } else {
            if (index < 0 || this.start + index >= this.end) {
                throw new ArrayIndexOutOfBoundsException("Index out of bounds");
            }
            this.cache[this.start + index] = newValue;
        }
        return newValue;
    }

    public double lastSet(int index, double newValue) {
        return this.set(this.end - index - 1, newValue);
    }

    public int hashCode() {
        int hashCode = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            hashCode = 31 * hashCode + Double.hashCode(this.fastGet(i));
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleList)) {
            return false;
        }
        DoubleList array = (DoubleList)o;
        if (this.cache == array.cache && this.start == array.start && this.end == array.end) {
            return true;
        }
        if (array.size() != this.size()) {
            return false;
        }
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (this.fastGet(i) == array.fastGet(i)) continue;
            return false;
        }
        return true;
    }

    public DoubleList clone() {
        return new DoubleList(this.cache, this.start, this.size());
    }

    public String toString() {
        TDoubleIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            double e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public void dropDuplicates() {
        if (this.size() <= 1) {
            return;
        }
        TDoubleHashSet existsElements = new TDoubleHashSet();
        int index = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            double element = this.fastGet(i);
            if (existsElements.contains(element)) continue;
            existsElements.add(element);
            this.cache[index++] = element;
        }
        existsElements.clear();
        this.start = 0;
        this.end = index;
    }

    public void fill(double value, int size) {
        if (size > 0) {
            this.checkCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.cache[this.end++] = value;
            }
        }
    }

    public void close() {
        this.start = 0;
        this.end = 0;
        this.cache = EmptyArray.DOUBLE;
    }

    public int binarySearch(double key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            double midVal = this.cache[this.start + mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int argmax() {
        if (this.size() == 0) {
            return -1;
        }
        double element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (!(element < this.fastGet(i))) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.size() == 0) {
            return -1;
        }
        double element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (!(element > this.fastGet(i))) continue;
            index = i;
        }
        return index;
    }

    public double max() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        double maxValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (!(maxValue < this.fastGet(i))) continue;
            maxValue = this.fastGet(i);
        }
        return maxValue;
    }

    public double min() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        double minValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (!(minValue > this.fastGet(i))) continue;
            minValue = this.fastGet(i);
        }
        return minValue;
    }

    public boolean all(IDoubleFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (rule.filter(this.fastGet(i))) continue;
            return false;
        }
        return true;
    }

    public boolean any(IDoubleFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            return true;
        }
        return false;
    }

    public int count(IDoubleFilter rule) {
        int count = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            ++count;
        }
        return count;
    }

    public TDoubleSet toSet() {
        TDoubleHashSet container = new TDoubleHashSet(this.size());
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            container.add(this.fastGet(i));
        }
        return container;
    }

    public TDoubleSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(IDoubleFilter function) {
        return new IndexIterator(this.size(), function == null ? null : index -> function.filter(this.fastGet(index)));
    }

    public DoubleList apply(TDoubleFunction function) {
        return this.apply(function, null);
    }

    public DoubleList apply(TDoubleFunction function, IDoubleFilter filter) {
        DoubleList result = new DoubleList(this.size());
        if (filter != null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                double value = function.execute(this.fastGet(i));
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                result.add(function.execute(this.fastGet(i)));
            }
        }
        return result;
    }

    public void applyInplace(TDoubleFunction function) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            this.cache[i] = function.execute(this.fastGet(i));
        }
        this.end = l;
        this.start = 0;
    }

    public DoubleList filter(IDoubleFilter filter) {
        DoubleList result = new DoubleList(1);
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            double c = this.fastGet(i);
            if (!filter.filter(c)) continue;
            result.add(c);
        }
        return result;
    }

    public void sort(int beginIndex, int endIndex) {
        Assert.that(beginIndex >= 0 && beginIndex <= this.size());
        Assert.that(endIndex >= beginIndex && endIndex <= this.size());
        Arrays.sort(this.cache, this.start + beginIndex, this.start + endIndex);
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public int indexOf(double element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(IDoubleFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastGet(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastLastGet(i)) continue;
            return l - i - 1;
        }
        return -1;
    }

    public int lastIndexOfIf(IDoubleFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastLastGet(i))) continue;
            return l - i - 1;
        }
        return -1;
    }

    public String toString(String joiner) {
        TDoubleIterator it = this.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            double e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.toString();
            }
            sb.append(joiner);
        }
    }

    public DoubleList asUnmodifiable() {
        return new DoubleList(){
            {
                this.cache = DoubleList.this.cache;
                this.start = DoubleList.this.start;
                this.end = DoubleList.this.end;
            }

            @Override
            public double popFirst() {
                throw new UnsupportedOperationException();
            }

            @Override
            public double popLast() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DoubleList popFirst(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public DoubleList popLast(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(double element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(double element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public double removeByIndex(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean insert(int index, double value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(double[] elements) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(double[] elements, int offset, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(DoubleList values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(IDoubleFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainIf(IDoubleFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double fastSet(int index, double newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double set(int index, double newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double lastSet(int index, double newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void dropDuplicates() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void applyInplace(TDoubleFunction function) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort(int beginIndex, int endIndex) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DoubleList asUnmodifiable() {
                return this;
            }

            @Override
            public void shuffle(long seed) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.end - 1; i > this.start; --i) {
            int j = this.start + random.nextInt(i - this.start + 1);
            double temp = this.cache[i];
            this.cache[i] = this.cache[j];
            this.cache[j] = temp;
        }
    }
}

